/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.privatechef;

import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Properties;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.chef.filters.SignedHeaderAuth;
import org.jclouds.chef.filters.SignedHeaderAuthTest;
import org.jclouds.chef.functions.ParseKeySetFromJson;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.http.functions.ReturnTrueIf2xx;
import org.jclouds.privatechef.PrivateChefApiMetadata;
import org.jclouds.privatechef.PrivateChefAsyncApi;
import org.jclouds.privatechef.config.PrivateChefRestClientModule;
import org.jclouds.privatechef.domain.Organization;
import org.jclouds.privatechef.domain.User;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnFalseOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.internal.BaseAsyncApiTest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="PrivateChefAsyncApiTest")
public class PrivateChefAsyncApiTest
extends BaseAsyncApiTest<PrivateChefAsyncApi> {
    public void testListUsers() throws SecurityException, NoSuchMethodException, IOException {
        Method method = PrivateChefAsyncApi.class.getMethod("listUsers", new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.opscode.com/users HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\nX-Chef-Version: 0.10.8-test\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseKeySetFromJson.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testUserExists() throws SecurityException, NoSuchMethodException, IOException {
        Method method = PrivateChefAsyncApi.class.getMethod("userExists", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"user"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "HEAD https://api.opscode.com/users/user HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\nX-Chef-Version: 0.10.8-test\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnFalseOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testOrganizationExists() throws SecurityException, NoSuchMethodException, IOException {
        Method method = PrivateChefAsyncApi.class.getMethod("organizationExists", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"organization"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "HEAD https://api.opscode.com/organizations/organization HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\nX-Chef-Version: 0.10.8-test\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnFalseOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListOrganizations() throws SecurityException, NoSuchMethodException, IOException {
        Method method = PrivateChefAsyncApi.class.getMethod("listOrganizations", new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.opscode.com/organizations HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\nX-Chef-Version: 0.10.8-test\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseKeySetFromJson.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateUser() throws SecurityException, NoSuchMethodException, IOException {
        Method method = PrivateChefAsyncApi.class.getMethod("createUser", User.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{new User("myuser")});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.opscode.com/users HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\nX-Chef-Version: 0.10.8-test\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "{\"username\":\"myuser\"}", "application/json", false);
        HttpRequest filteredRequest = ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals(filteredRequest, "POST https://api.opscode.com/users HTTP/1.1");
        this.assertNonPayloadHeadersEqual(filteredRequest, "Accept: application/json" + "\n" + "X-Chef-Version: 0.10.8-test" + "\n" + "X-Ops-Authorization-1: kfrkDpfgNU26k70R1vl1bEWk0Q0f9Fs/3kxOX7gHd7iNoJq03u7RrcrAOSgL" + "\n" + "X-Ops-Authorization-2: ETj5JNeCk18BmFkHMAbCA9hXVo1T4rlHCpbuzAzFlFxUGAT4wj8UoO7V886X" + "\n" + "X-Ops-Authorization-3: Kf8DvihP6ElthCNuu1xuhN0B4GEmWC9+ut7UMLe0L2T34VzkbCtuInGbf42/" + "\n" + "X-Ops-Authorization-4: G7iu94/xFOT1gN9cex4pNyTnRCHzob4JVU1usxt/2g5grN2SyYwRS5+4MNLN" + "\n" + "X-Ops-Authorization-5: WY/iLUPb/9dwtiIQsnUOXqDrs28zNswZulQW4AzYRd7MczJVKU4y4+4XRcB4" + "\n" + "X-Ops-Authorization-6: 2+BFLT5o6P6G0D+eCu3zSuaqEJRucPJPaDGWdKIMag==" + "\n" + "X-Ops-Content-Hash: yLHOxvgIEtNw5UrZDxslOeMw1gw=" + "\n" + "X-Ops-Sign: version=1.0" + "\n" + "X-Ops-Timestamp: timestamp" + "\n" + "X-Ops-Userid: user" + "\n");
        this.assertPayloadEquals(filteredRequest, "{\"username\":\"myuser\"}", "application/json", false);
        this.assertResponseParserClassEquals(method, filteredRequest, ParseJson.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters(filteredRequest);
    }

    public void testUpdateUser() throws SecurityException, NoSuchMethodException, IOException {
        Method method = PrivateChefAsyncApi.class.getMethod("updateUser", User.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{new User("myuser")});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "PUT https://api.opscode.com/users/myuser HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\nX-Chef-Version: 0.10.8-test\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "{\"username\":\"myuser\"}", "application/json", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseJson.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetUser() throws SecurityException, NoSuchMethodException, IOException {
        Method method = PrivateChefAsyncApi.class.getMethod("getUser", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"myuser"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.opscode.com/users/myuser HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\nX-Chef-Version: 0.10.8-test\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseJson.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDeleteUser() throws SecurityException, NoSuchMethodException, IOException {
        Method method = PrivateChefAsyncApi.class.getMethod("deleteUser", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"myuser"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "DELETE https://api.opscode.com/users/myuser HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\nX-Chef-Version: 0.10.8-test\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseJson.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateOrg() throws SecurityException, NoSuchMethodException, IOException {
        Method method = PrivateChefAsyncApi.class.getMethod("createOrganization", Organization.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{new Organization("myorganization", "myorganization", "myorganization-validator", "Business")});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.opscode.com/organizations HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\nX-Chef-Version: 0.10.8-test\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "{\"name\":\"myorganization\",\"full_name\":\"myorganization\",\"clientname\":\"myorganization-validator\",\"org_type\":\"Business\"}", "application/json", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseJson.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testUpdateOrg() throws SecurityException, NoSuchMethodException, IOException {
        Method method = PrivateChefAsyncApi.class.getMethod("updateOrganization", Organization.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{new Organization("myorganization", "myorganization", "myorganization-validator", "Business")});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "PUT https://api.opscode.com/organizations/myorganization HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\nX-Chef-Version: 0.10.8-test\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "{\"name\":\"myorganization\",\"full_name\":\"myorganization\",\"clientname\":\"myorganization-validator\",\"org_type\":\"Business\"}", "application/json", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseJson.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetOrg() throws SecurityException, NoSuchMethodException, IOException {
        Method method = PrivateChefAsyncApi.class.getMethod("getOrganization", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"myorganization"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.opscode.com/organizations/myorganization HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\nX-Chef-Version: 0.10.8-test\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseJson.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDeleteOrg() throws SecurityException, NoSuchMethodException, IOException {
        Method method = PrivateChefAsyncApi.class.getMethod("deleteOrganization", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"myorganization"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "DELETE https://api.opscode.com/organizations/myorganization HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\nX-Chef-Version: 0.10.8-test\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseJson.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), SignedHeaderAuth.class);
    }

    protected TypeLiteral<RestAnnotationProcessor<PrivateChefAsyncApi>> createTypeLiteral() {
        return new TypeLiteral<RestAnnotationProcessor<PrivateChefAsyncApi>>(){};
    }

    protected Module createModule() {
        return new TestPrivateChefRestClientModule();
    }

    protected Properties setupProperties() {
        Properties props = super.setupProperties();
        props.put("jclouds.api-version", "0.10.8-test");
        return props;
    }

    public ApiMetadata createApiMetadata() {
        this.identity = "user";
        this.credential = SignedHeaderAuthTest.PRIVATE_KEY;
        return new PrivateChefApiMetadata();
    }

    @ConfiguresRestClient
    static class TestPrivateChefRestClientModule
    extends PrivateChefRestClientModule {
        TestPrivateChefRestClientModule() {
        }

        protected String provideTimeStamp(@TimeStamp Supplier<String> cache) {
            return "timestamp";
        }
    }
}

