/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.privatechef.functions;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import org.jclouds.chef.config.ChefParserModule;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.config.GsonModule;
import org.jclouds.privatechef.domain.Organization;
import org.jclouds.rest.annotations.ApiVersion;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, sequential=true)
public class ParseOrganizationFromJsonTest {
    private ParseJson<Organization> handler;

    @BeforeTest
    protected void setUpInjector() throws IOException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(String.class).annotatedWith(ApiVersion.class).toInstance((Object)"0.10.8");
            }
        }, new ChefParserModule(), new GsonModule()});
        this.handler = (ParseJson)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<ParseJson<Organization>>(){}));
    }

    public void test() {
        Organization org = new Organization("486ca3ac66264fea926aa0b4ff74341c", "jclouds", "jclouds", "jclouds-validator", "Business", null);
        String toParse = "{\"guid\":\"486ca3ac66264fea926aa0b4ff74341c\",\"name\":\"jclouds\",\"full_name\":\"jclouds\",\"clientname\":\"jclouds-validator\",\"org_type\":\"Business\",\"name\":\"jclouds\"}";
        Assert.assertEquals((Object)this.handler.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(toParse)).build()), (Object)org);
    }
}

