/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.privatechef.domain;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.security.PrivateKey;

public class Organization {
    private String guid;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="full_name")
    private String fullName;
    private String clientname;
    @SerializedName(value="org_type")
    private String orgType;
    @SerializedName(value="private_key")
    private PrivateKey privateKey;

    Organization() {
    }

    public Organization(String name, String fullName, String clientname, String orgType) {
        this(null, name, fullName, clientname, orgType, null);
    }

    public Organization(String name, String orgType) {
        this(null, name, name, name + "-validator", orgType, null);
    }

    public Organization(String guid, String name, String fullName, String clientname, String orgType, PrivateKey privateKey) {
        this.guid = guid;
        this.name = name;
        this.fullName = fullName;
        this.clientname = (String)Preconditions.checkNotNull((Object)clientname, (Object)"clientname");
        this.orgType = (String)Preconditions.checkNotNull((Object)orgType, (Object)"orgType");
        this.privateKey = privateKey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clientname == null ? 0 : this.clientname.hashCode());
        result = 31 * result + (this.fullName == null ? 0 : this.fullName.hashCode());
        result = 31 * result + (this.guid == null ? 0 : this.guid.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.orgType == null ? 0 : this.orgType.hashCode());
        result = 31 * result + (this.privateKey == null ? 0 : this.privateKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Organization other = (Organization)obj;
        if (this.clientname == null ? other.clientname != null : !this.clientname.equals(other.clientname)) {
            return false;
        }
        if (this.fullName == null ? other.fullName != null : !this.fullName.equals(other.fullName)) {
            return false;
        }
        if (this.guid == null ? other.guid != null : !this.guid.equals(other.guid)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.orgType == null ? other.orgType != null : !this.orgType.equals(other.orgType)) {
            return false;
        }
        return !(this.privateKey == null ? other.privateKey != null : !this.privateKey.equals(other.privateKey));
    }

    public String getGuid() {
        return this.guid;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getApiname() {
        return this.clientname;
    }

    public String getOrgType() {
        return this.orgType;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public String toString() {
        return "[name=" + this.name + ", clientname=" + this.clientname + ", fullName=" + this.fullName + ", guid=" + this.guid + ", orgType=" + this.orgType + ", privateKey=" + (this.privateKey != null) + "]";
    }

    public static interface Type {
        public static final String BUSINESS = "Business";
        public static final String NON_PROFIT = "Non-Profit";
        public static final String PERSONAL = "Personal";
    }
}

