/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.privatechef.functions;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import org.jclouds.chef.config.ChefParserModule;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.Pems;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.config.GsonModule;
import org.jclouds.privatechef.domain.User;
import org.jclouds.rest.annotations.ApiVersion;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, sequential=true)
public class ParseUserFromJsonTest {
    private ParseJson<User> handler;
    private Crypto crypto;

    @BeforeTest
    protected void setUpInjector() throws IOException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(String.class).annotatedWith(ApiVersion.class).toInstance((Object)"0.10.8");
            }
        }, new ChefParserModule(), new GsonModule()});
        this.handler = (ParseJson)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<ParseJson<User>>(){}));
        this.crypto = (Crypto)injector.getInstance(Crypto.class);
    }

    @Test(enabled=false)
    public void test() throws InvalidKeySpecException, CertificateException, IOException {
        User user = new User("dopey", "Adrian", "", "Cole", "Adrian Cole", "adrian+dopey@opscode.com", null, null, null, null, "abcdef", this.crypto.rsaKeyFactory().generatePublic(Pems.publicKeySpec((String)"-----BEGIN RSA PUBLIC KEY-----\nMIIBCgKCAQEAvCKTqPdHv7GsHTjk02g91Aw3T6xQmdRaI70X6E6GGFxZtcH+tb1X\nqHxwhFydECVXhu0WVjTcWvxZ1aMFzn9BLHQYWzZxU/fIKVNR6ujyZ3jRxDXRFpX5\n/zvMdvNbdsJ+8foEbdoP1iujUMZuy6ZMvcbTDCgWjYVQ2omR9CkH/5Fwlbk3cSrF\n6qfGaM7340OGknKUfXdvhCq4vxydlOwfHJyNDWY0PW+8rDKHWxxNtYDDDeIMw2z/\nYC34f1bcAkR+/lyx5b25RwDomZNqXJqp1hjOVJVlo+UMvzWfXph5hgjcgtwzc5Iu\nmWWMUdxLcdw+/iQm6NW9cmU28bvHu0q7FwIDAQAB\n-----END RSA PUBLIC KEY-----\n")), null, Pems.x509Certificate((String)"-----BEGIN CERTIFICATE-----\nMIIClzCCAgCgAwIBAgIBATANBgkqhkiG9w0BAQUFADCBnjELMAkGA1UEBhMCVVMx\nEzARBgNVBAgMCldhc2hpbmd0b24xEDAOBgNVBAcMB1NlYXR0bGUxFjAUBgNVBAoM\nDU9wc2NvZGUsIEluYy4xHDAaBgNVBAsME0NlcnRpZmljYXRlIFNlcnZpY2UxMjAw\nBgNVBAMMKW9wc2NvZGUuY29tL2VtYWlsQWRkcmVzcz1hdXRoQG9wc2NvZGUuY29t\nMB4XDTEwMDgwMzA0MDUzNVoXDTIwMDczMTA0MDUzNVowADCCASIwDQYJKoZIhvcN\nAQEBBQADggEPADCCAQoCggEBALwik6j3R7+xrB045NNoPdQMN0+sUJnUWiO9F+hO\nhhhcWbXB/rW9V6h8cIRcnRAlV4btFlY03Fr8WdWjBc5/QSx0GFs2cVP3yClTUero\n8md40cQ10RaV+f87zHbzW3bCfvH6BG3aD9Yro1DGbsumTL3G0wwoFo2FUNqJkfQp\nB/+RcJW5N3EqxeqnxmjO9+NDhpJylH13b4QquL8cnZTsHxycjQ1mND1vvKwyh1sc\nTbWAww3iDMNs/2At+H9W3AJEfv5cseW9uUcA6JmTalyaqdYYzlSVZaPlDL81n16Y\neYYI3ILcM3OSLplljFHcS3HcPv4kJujVvXJlNvG7x7tKuxcCAwEAATANBgkqhkiG\n9w0BAQUFAAOBgQBcoSP/2tFhP8yjF/dRDRdDed0/Cg0xnpp2wvM38gBRgvhpZbQ3\nI2rqpw5THNzrzBVnrYxd57uAa+y2MMG57XnvNWOmyL6WIYXLfN1QI3nHdpHS/QVF\nCRWpDWxLM1TkqAD9xQZOpUDdByF2exiCDNTzSYYg/ISLlIEzicNJeoPNbA==\n-----END CERTIFICATE-----\n"), "xBOmipWikVEicS7tNOPdQzPsPmsROMgPme5O19ZHh6R7N9MQT7d5olDiGFpO");
        Assert.assertEquals((Object)this.handler.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(ParseUserFromJsonTest.class.getResourceAsStream("/user.json"))).build()), (Object)user);
    }
}

