/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.glance.v1_0.functions;

import com.google.common.base.Function;
import javax.inject.Inject;
import org.jclouds.date.DateService;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.glance.v1_0.domain.ContainerFormat;
import org.jclouds.openstack.glance.v1_0.domain.DiskFormat;
import org.jclouds.openstack.glance.v1_0.domain.Image;
import org.jclouds.openstack.glance.v1_0.domain.ImageDetails;
import org.jclouds.openstack.glance.v1_0.options.ImageField;

public class ParseImageDetailsFromHeaders
implements Function<HttpResponse, ImageDetails> {
    private final DateService dateService;

    @Inject
    public ParseImageDetailsFromHeaders(DateService dateService) {
        this.dateService = dateService;
    }

    public ImageDetails apply(HttpResponse from) {
        Object builder = ((ImageDetails.Builder)((Object)((ImageDetails.Builder)((Object)((ImageDetails.Builder)((Object)((ImageDetails.Builder)((Object)((ImageDetails.Builder)((Object)((ImageDetails.Builder)((Object)((ImageDetails.Builder)((Object)((ImageDetails.Builder)((Object)((ImageDetails.Builder)((ImageDetails.Builder)ImageDetails.builder().id(from.getFirstHeaderOrNull(ImageField.ID.asHeader()))).name(from.getFirstHeaderOrNull(ImageField.NAME.asHeader()))).checksum(from.getFirstHeaderOrNull(ImageField.CHECKSUM.asHeader())))).minDisk(Long.parseLong(from.getFirstHeaderOrNull(ImageField.MIN_DISK.asHeader()))))).minRam(Long.parseLong(from.getFirstHeaderOrNull(ImageField.MIN_RAM.asHeader()))))).isPublic(Boolean.parseBoolean(from.getFirstHeaderOrNull(ImageField.IS_PUBLIC.asHeader()))))).createdAt(this.dateService.iso8601SecondsDateParse(from.getFirstHeaderOrNull(ImageField.CREATED_AT.asHeader()))))).updatedAt(this.dateService.iso8601SecondsDateParse(from.getFirstHeaderOrNull(ImageField.UPDATED_AT.asHeader()))))).owner(from.getFirstHeaderOrNull(ImageField.OWNER.asHeader())))).location(from.getFirstHeaderOrNull(ImageField.LOCATION.asHeader())))).status(Image.Status.fromValue(from.getFirstHeaderOrNull(ImageField.STATUS.asHeader())));
        String containerFormat = from.getFirstHeaderOrNull(ImageField.CONTAINER_FORMAT.asHeader());
        String diskFormat = from.getFirstHeaderOrNull(ImageField.DISK_FORMAT.asHeader());
        String deletedAt = from.getFirstHeaderOrNull(ImageField.DELETED_AT.asHeader());
        String size = from.getFirstHeaderOrNull(ImageField.SIZE.asHeader());
        if (containerFormat != null) {
            ((Image.Builder)((Object)builder)).containerFormat(ContainerFormat.fromValue(containerFormat));
        }
        if (diskFormat != null) {
            ((Image.Builder)((Object)builder)).diskFormat(DiskFormat.fromValue(diskFormat));
        }
        if (deletedAt != null) {
            ((ImageDetails.Builder)((Object)builder)).deletedAt(this.dateService.iso8601SecondsDateParse(deletedAt));
        }
        if (size != null) {
            ((Image.Builder)((Object)builder)).size(Long.parseLong(size));
        }
        return ((ImageDetails.Builder)((Object)builder)).build();
    }
}

