/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.glance.v1_0.domain;

import com.google.common.base.Preconditions;

public enum DiskFormat {
    RAW,
    VHD,
    VMDK,
    VDI,
    ISO,
    QCOW2,
    AKI,
    ARI,
    AMI,
    UNRECOGNIZED;


    public String value() {
        return this.name().toLowerCase();
    }

    public String toString() {
        return this.value();
    }

    public static DiskFormat fromValue(String diskFormat) {
        try {
            return DiskFormat.valueOf(((String)Preconditions.checkNotNull((Object)diskFormat, (Object)"diskFormat")).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return UNRECOGNIZED;
        }
    }
}

