/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.util;

import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.aws.domain.AWSError;
import org.jclouds.aws.xml.ErrorHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;
import org.jclouds.rest.RequestSigner;

@Singleton
public class AWSUtils {
    private final RequestSigner signer;
    private final ParseSax.Factory factory;
    private final Provider<ErrorHandler> errorHandlerProvider;
    private final String requestId;
    private final String requestToken;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    AWSUtils(@Named(value="jclouds.aws.header.tag") String headerTag, RequestSigner signer, ParseSax.Factory factory, Provider<ErrorHandler> errorHandlerProvider) {
        this.signer = signer;
        this.factory = factory;
        this.errorHandlerProvider = errorHandlerProvider;
        this.requestId = String.format("x-%s-request-id", headerTag);
        this.requestToken = String.format("x-%s-id-2", headerTag);
    }

    public AWSError parseAWSErrorFromContent(HttpRequest request, HttpResponse response) {
        if (response.getPayload() == null) {
            return null;
        }
        if (response.getPayload().getContentMetadata().getContentType() != null && response.getPayload().getContentMetadata().getContentType().indexOf("text/plain") != -1) {
            return null;
        }
        try {
            AWSError error = (AWSError)this.factory.create((ParseSax.HandlerWithResult)this.errorHandlerProvider.get()).setContext(request).apply(response);
            if (error.getRequestId() == null) {
                error.setRequestId(response.getFirstHeaderOrNull(this.requestId));
            }
            error.setRequestToken(response.getFirstHeaderOrNull(this.requestToken));
            if ("SignatureDoesNotMatch".equals(error.getCode())) {
                error.setStringSigned(this.signer.createStringToSign(request));
                error.setSignature(this.signer.sign(error.getStringSigned()));
            }
            return error;
        }
        catch (RuntimeException e) {
            this.logger.warn((Throwable)e, "error parsing error", new Object[0]);
            return null;
        }
    }
}

