/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.suppliers;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.Region;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;

@Singleton
public class DefaultLocationSupplier
implements Supplier<Location> {
    private final String region;
    private final Supplier<Set<? extends Location>> set;

    @Inject
    DefaultLocationSupplier(@Region String region, @Memoized Supplier<Set<? extends Location>> set) {
        this.region = region;
        this.set = set;
    }

    @Singleton
    public Location get() {
        try {
            Location toReturn = (Location)Iterables.find((Iterable)((Iterable)this.set.get()), (Predicate)new Predicate<Location>(){

                public boolean apply(Location input) {
                    switch (input.getScope()) {
                        case ZONE: {
                            return input.getParent().getId().equals(DefaultLocationSupplier.this.region);
                        }
                        case REGION: {
                            return input.getId().equals(DefaultLocationSupplier.this.region);
                        }
                    }
                    return false;
                }
            });
            return toReturn.getScope() == LocationScope.REGION ? toReturn : toReturn.getParent();
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException(String.format("region: %s not found in %s", this.region, this.set));
        }
    }
}

