/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.sqs.xml.internal;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.sqs.domain.Queue;

@Singleton
public class BaseRegexQueueHandler {
    private final ImmutableBiMap<URI, String> uriToRegion;
    Pattern pattern = Pattern.compile("<QueueUrl>(https://[\\S&&[^<]]+)</QueueUrl>");

    @Inject
    protected BaseRegexQueueHandler(Map<String, URI> regionMap) {
        this.uriToRegion = ImmutableBiMap.builder().putAll(regionMap).build().inverse();
    }

    public Set<Queue> parse(String in) {
        LinkedHashSet queues = Sets.newLinkedHashSet();
        Matcher matcher = this.pattern.matcher(in);
        while (matcher.find()) {
            String uriText = matcher.group(1);
            String queueName = uriText.substring(uriText.lastIndexOf(47) + 1);
            URI location = URI.create(uriText);
            String regionString = uriText.substring(0, uriText.indexOf(".com/") + 4);
            URI regionURI = URI.create(regionString);
            String region = (String)this.uriToRegion.get((Object)regionURI);
            queues.add(new Queue(region, queueName, location));
        }
        return queues;
    }
}

