/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.sqs.xml;

import com.google.common.base.Function;
import com.google.inject.Singleton;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ReturnStringIf2xx;

@Singleton
public class RegexMD5Handler
implements Function<HttpResponse, byte[]> {
    Pattern pattern = Pattern.compile("<MD5OfMessageBody>([\\S&&[^<]]+)</MD5OfMessageBody>");
    private final ReturnStringIf2xx returnStringIf200;

    @Inject
    RegexMD5Handler(ReturnStringIf2xx returnStringIf200) {
        this.returnStringIf200 = returnStringIf200;
    }

    public byte[] apply(HttpResponse response) {
        Matcher matcher;
        byte[] value = null;
        String content = this.returnStringIf200.apply(response);
        if (content != null && (matcher = this.pattern.matcher(content)).find()) {
            value = CryptoStreams.hex((String)matcher.group(1));
        }
        return value;
    }
}

