/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.sqs.xml;

import com.google.common.collect.ImmutableBiMap;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.aws.Region;
import org.jclouds.aws.sqs.domain.Queue;
import org.jclouds.http.functions.ParseSax;

public class QueueHandler
extends ParseSax.HandlerWithResult<Queue> {
    private StringBuilder currentText = new StringBuilder();
    Queue queue;
    private final ImmutableBiMap<String, URI> regionBiMap;
    private final Provider<UriBuilder> uriBuilderProvider;

    @Inject
    QueueHandler(Provider<UriBuilder> uriBuilderProvider, @Region Map<String, URI> regionMap) {
        this.uriBuilderProvider = uriBuilderProvider;
        this.regionBiMap = ImmutableBiMap.builder().putAll(regionMap).build();
    }

    public Queue getResult() {
        return this.queue;
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("QueueUrl")) {
            String uriText = this.currentText.toString().trim();
            String queueName = uriText.substring(uriText.lastIndexOf(47) + 1);
            URI location = URI.create(uriText);
            URI regionURI = ((UriBuilder)this.uriBuilderProvider.get()).uri(location).replacePath("").build(new Object[0]);
            String region = (String)this.regionBiMap.inverse().get((Object)regionURI);
            this.queue = new Queue(region, queueName, location);
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

