/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.sqs.domain;

import com.google.common.base.Preconditions;
import java.net.URI;

public class Queue
implements Comparable<Queue> {
    private final String region;
    private final String name;
    private final URI location;

    public Queue(String region, String name, URI location) {
        this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"region");
        this.location = (URI)Preconditions.checkNotNull((Object)location, (Object)"location");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
    }

    @Override
    public int compareTo(Queue o) {
        return this.location.toASCIIString().compareTo(o.location.toASCIIString());
    }

    public String getRegion() {
        return this.region;
    }

    public URI getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Queue other = (Queue)obj;
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.region == null ? other.region != null : !this.region.equals(other.region));
    }

    public String toString() {
        return "Queue [location=" + this.location + ", name=" + this.name + ", region=" + this.region + "]";
    }
}

