/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.sqs;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.aws.functions.RegionToEndpoint;
import org.jclouds.aws.sqs.domain.Queue;
import org.jclouds.aws.sqs.functions.QueueLocation;
import org.jclouds.aws.sqs.options.CreateQueueOptions;
import org.jclouds.aws.sqs.options.ListQueuesOptions;
import org.jclouds.aws.sqs.xml.RegexListQueuesResponseHandler;
import org.jclouds.aws.sqs.xml.RegexMD5Handler;
import org.jclouds.aws.sqs.xml.RegexQueueHandler;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.VirtualHost;

@RequestFilters(value={FormSigner.class})
@FormParams(keys={"Version"}, values={"2009-02-01"})
@VirtualHost
public interface SQSAsyncClient {
    public static final String VERSION = "2009-02-01";

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"ListQueues"})
    @ResponseParser(value=RegexListQueuesResponseHandler.class)
    public ListenableFuture<? extends Set<Queue>> listQueuesInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, ListQueuesOptions ... var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CreateQueue"})
    @ResponseParser(value=RegexQueueHandler.class)
    public ListenableFuture<Queue> createQueueInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="QueueName") String var2, CreateQueueOptions ... var3);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeleteQueue"})
    public ListenableFuture<Void> deleteQueue(@EndpointParam(parser=QueueLocation.class) Queue var1);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"SendMessage"})
    @ResponseParser(value=RegexMD5Handler.class)
    public ListenableFuture<byte[]> sendMessage(@EndpointParam(parser=QueueLocation.class) Queue var1, @FormParam(value="MessageBody") String var2);
}

