/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.xml;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.aws.s3.domain.CanonicalUser;
import org.jclouds.aws.s3.domain.ListBucketResponse;
import org.jclouds.aws.s3.domain.ObjectMetadata;
import org.jclouds.aws.s3.domain.internal.BucketListObjectMetadata;
import org.jclouds.aws.s3.domain.internal.ListBucketResponseImpl;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.Utils;
import org.xml.sax.Attributes;

public class ListBucketHandler
extends ParseSax.HandlerWithResult<ListBucketResponse> {
    private Set<ObjectMetadata> contents;
    private Set<String> commonPrefixes;
    private CanonicalUser currentOwner;
    private StringBuilder currentText = new StringBuilder();
    private final DateService dateParser;
    private String bucketName;
    private String prefix;
    private String marker;
    private int maxResults;
    private String delimiter;
    private boolean isTruncated;
    private boolean inCommonPrefixes;
    private String currentKey;
    private Date currentLastModified;
    private String currentETag;
    private byte[] currentMD5;
    private long currentSize;
    private ObjectMetadata.StorageClass currentStorageClass;
    private String nextMarker;

    @Inject
    public ListBucketHandler(DateService dateParser) {
        this.dateParser = dateParser;
        this.contents = Sets.newLinkedHashSet();
        this.commonPrefixes = Sets.newLinkedHashSet();
    }

    public ListBucketResponse getResult() {
        return new ListBucketResponseImpl(this.bucketName, this.contents, this.prefix, this.marker, this.nextMarker, this.maxResults, this.delimiter, this.isTruncated, this.commonPrefixes);
    }

    public void startElement(String uri, String name, String qName, Attributes attrs) {
        if (qName.equals("CommonPrefixes")) {
            this.inCommonPrefixes = true;
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("ID")) {
            this.currentOwner = new CanonicalUser(this.currentText.toString().trim());
        } else if (qName.equals("DisplayName")) {
            this.currentOwner.setDisplayName(this.currentText.toString().trim());
        } else if (qName.equals("Key")) {
            this.currentKey = this.currentText.toString().trim();
        } else if (qName.equals("LastModified")) {
            this.currentLastModified = this.dateParser.iso8601DateParse(this.currentText.toString().trim());
        } else if (qName.equals("ETag")) {
            this.currentETag = this.currentText.toString().trim();
            this.currentMD5 = CryptoStreams.hex((String)Utils.replaceAll((String)this.currentETag, (char)'\"', (String)""));
        } else if (qName.equals("Size")) {
            this.currentSize = new Long(this.currentText.toString().trim());
        } else if (!qName.equals("Owner")) {
            if (qName.equals("StorageClass")) {
                this.currentStorageClass = ObjectMetadata.StorageClass.valueOf(this.currentText.toString().trim());
            } else if (qName.equals("Contents")) {
                this.contents.add(new BucketListObjectMetadata(this.currentKey, this.currentLastModified, this.currentETag, this.currentMD5, this.currentSize, this.currentOwner, this.currentStorageClass));
            } else if (qName.equals("Name")) {
                this.bucketName = this.currentText.toString().trim();
            } else if (qName.equals("Prefix")) {
                String prefix = this.currentText.toString().trim();
                if (this.inCommonPrefixes) {
                    this.commonPrefixes.add(prefix);
                } else {
                    this.prefix = prefix;
                }
            } else if (qName.equals("Delimiter")) {
                if (!this.currentText.toString().equals("")) {
                    this.delimiter = this.currentText.toString().trim();
                }
            } else if (qName.equals("Marker")) {
                if (!this.currentText.toString().equals("")) {
                    this.marker = this.currentText.toString().trim();
                }
            } else if (qName.equals("NextMarker")) {
                if (!this.currentText.toString().equals("")) {
                    this.nextMarker = this.currentText.toString().trim();
                }
            } else if (qName.equals("MaxKeys")) {
                this.maxResults = Integer.parseInt(this.currentText.toString().trim());
            } else if (qName.equals("IsTruncated")) {
                this.isTruncated = Boolean.parseBoolean(this.currentText.toString().trim());
            }
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

