/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.xml;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.aws.s3.domain.BucketMetadata;
import org.jclouds.aws.s3.domain.CanonicalUser;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;

public class ListAllMyBucketsHandler
extends ParseSax.HandlerWithResult<Set<BucketMetadata>> {
    private Set<BucketMetadata> buckets = Sets.newLinkedHashSet();
    private CanonicalUser currentOwner;
    private StringBuilder currentText = new StringBuilder();
    private final DateService dateParser;
    private String currentName;
    private Date currentCreationDate;

    @Inject
    public ListAllMyBucketsHandler(DateService dateParser) {
        this.dateParser = dateParser;
    }

    public Set<BucketMetadata> getResult() {
        return this.buckets;
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("ID")) {
            this.currentOwner = new CanonicalUser(this.currentText.toString().trim());
        } else if (qName.equals("DisplayName")) {
            this.currentOwner.setDisplayName(this.currentText.toString().trim());
        } else if (qName.equals("Bucket")) {
            this.buckets.add(new BucketMetadata(this.currentName, this.currentCreationDate, this.currentOwner));
        } else if (qName.equals("Name")) {
            this.currentName = this.currentText.toString().trim();
        } else if (qName.equals("CreationDate")) {
            this.currentCreationDate = this.dateParser.iso8601DateParse(this.currentText.toString().trim());
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

