/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.xml;

import org.jclouds.aws.s3.domain.AccessControlList;
import org.jclouds.aws.s3.domain.CanonicalUser;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.Attributes;

public class AccessControlListHandler
extends ParseSax.HandlerWithResult<AccessControlList> {
    private AccessControlList acl = new AccessControlList();
    private StringBuilder currentText = new StringBuilder();
    private String currentId;
    private String currentDisplayName;
    private String currentGranteeType;
    private String currentPermission;
    private AccessControlList.Grantee currentGrantee;

    public AccessControlList getResult() {
        return this.acl;
    }

    public void startElement(String uri, String name, String qName, Attributes attrs) {
        if (qName.equals("Grantee")) {
            this.currentGranteeType = attrs.getValue("xsi:type");
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("Owner")) {
            CanonicalUser owner = new CanonicalUser(this.currentId);
            owner.setDisplayName(this.currentDisplayName);
            this.acl.setOwner(owner);
        } else if (qName.equals("Grantee")) {
            if ("AmazonCustomerByEmail".equals(this.currentGranteeType)) {
                this.currentGrantee = new AccessControlList.EmailAddressGrantee(this.currentId);
            } else if ("CanonicalUser".equals(this.currentGranteeType)) {
                this.currentGrantee = new AccessControlList.CanonicalUserGrantee(this.currentId, this.currentDisplayName);
            } else if ("Group".equals(this.currentGranteeType)) {
                this.currentGrantee = new AccessControlList.GroupGrantee(AccessControlList.GroupGranteeURI.fromURI(this.currentId));
            }
        } else if (qName.equals("Grant")) {
            this.acl.addPermission(this.currentGrantee, AccessControlList.Permission.valueOf(this.currentPermission));
        } else if (qName.equals("ID") || qName.equals("EmailAddress") || qName.equals("URI")) {
            this.currentId = this.currentText.toString();
        } else if (qName.equals("DisplayName")) {
            this.currentDisplayName = this.currentText.toString();
        } else if (qName.equals("Permission")) {
            this.currentPermission = this.currentText.toString();
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

