/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.util;

import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import org.jclouds.aws.s3.S3Client;
import org.jclouds.util.Patterns;

public class S3Utils {
    public static final Pattern BUCKET_NAME_PATTERN = Pattern.compile("^[a-z0-9][-_.a-z0-9]+");

    public static String validateBucketName(String bucketName) {
        Preconditions.checkNotNull((Object)bucketName, (Object)"bucketName");
        Preconditions.checkArgument((boolean)BUCKET_NAME_PATTERN.matcher(bucketName).matches(), (Object)"bucketName name must start with a number or letter and  can only contain lowercase letters, numbers, periods (.), underscores (_), and dashes (-)");
        Preconditions.checkArgument((bucketName.length() > 2 && bucketName.length() < 256 ? 1 : 0) != 0, (Object)"bucketName name must be between 3 and 255 characters long");
        Preconditions.checkArgument((!Patterns.IP_PATTERN.matcher(bucketName).matches() ? 1 : 0) != 0, (Object)"bucketName name cannot be ip address style");
        return bucketName;
    }

    public static boolean deleteAndVerifyContainerGone(S3Client sync, String container) {
        sync.deleteBucketIfEmpty(container);
        return sync.bucketExists(container);
    }
}

