/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.inject.Singleton;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.http.HttpUtils;
import org.jclouds.util.Utils;

@Singleton
public class ReturnTrueOn404OrNotFoundFalseIfNotEmpty
implements Function<Exception, Boolean> {
    public Boolean apply(Exception from) {
        List throwables = Throwables.getCausalChain((Throwable)from);
        Iterable matchingAWSResponseException = Iterables.filter((Iterable)throwables, AWSResponseException.class);
        if (Iterables.size((Iterable)matchingAWSResponseException) >= 1 && ((AWSResponseException)((Object)Iterables.get((Iterable)matchingAWSResponseException, (int)0))).getError() != null && ((AWSResponseException)((Object)Iterables.get((Iterable)matchingAWSResponseException, (int)0))).getError().getCode().equals("BucketNotEmpty")) {
            return false;
        }
        Iterable matchingContainerNotFoundException = Iterables.filter((Iterable)throwables, ContainerNotFoundException.class);
        if (Iterables.size((Iterable)matchingContainerNotFoundException) >= 1) {
            return true;
        }
        if (HttpUtils.returnValueOnCodeOrNull((Exception)from, (Object)true, (Predicate)Predicates.equalTo((Object)404)) != null) {
            return true;
        }
        return (Boolean)Boolean.class.cast(Utils.propagateOrNull((Exception)from));
    }
}

