/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.aws.s3.blobstore.functions.BlobToObjectMetadata;
import org.jclouds.aws.s3.domain.MutableObjectMetadata;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.functions.ParseSystemAndUserMetadataFromHeaders;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.InvocationContext;

public class ParseObjectMetadataFromHeaders
implements Function<HttpResponse, MutableObjectMetadata>,
InvocationContext {
    private final ParseSystemAndUserMetadataFromHeaders blobMetadataParser;
    private final BlobToObjectMetadata blobToObjectMetadata;
    private final String userMdPrefix;

    @Inject
    public ParseObjectMetadataFromHeaders(ParseSystemAndUserMetadataFromHeaders blobMetadataParser, BlobToObjectMetadata blobToObjectMetadata, @Named(value="jclouds.blobstore.metaprefix") String userMdPrefix) {
        this.blobMetadataParser = blobMetadataParser;
        this.blobToObjectMetadata = blobToObjectMetadata;
        this.userMdPrefix = userMdPrefix;
    }

    public MutableObjectMetadata apply(HttpResponse from) {
        MutableBlobMetadata base = this.blobMetadataParser.apply(from);
        MutableObjectMetadata to = this.blobToObjectMetadata.apply((BlobMetadata)base);
        this.addETagTo(from, to);
        if (to.getContentMetadata().getContentMD5() == null && to.getETag() != null) {
            byte[] md5 = CryptoStreams.hex((String)to.getETag().replaceAll("\"", ""));
            from.getPayload().getContentMetadata().setContentMD5(md5);
            to.getContentMetadata().setContentMD5(md5);
        }
        to.setCacheControl(from.getFirstHeaderOrNull("Cache-Control"));
        return to;
    }

    @VisibleForTesting
    protected void addETagTo(HttpResponse from, MutableObjectMetadata metadata) {
        String eTagHeader;
        if (metadata.getETag() == null && (eTagHeader = from.getFirstHeaderOrNull(this.userMdPrefix + "object-eTag")) != null) {
            metadata.setETag(eTagHeader);
        }
    }

    public ParseObjectMetadataFromHeaders setContext(HttpRequest request) {
        this.blobMetadataParser.setContext(request);
        return this;
    }
}

