/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.functions;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.logging.Logger;
import org.jclouds.rest.binders.BindToStringPayload;

@Singleton
public class BindRegionToXmlPayload
extends BindToStringPayload {
    @Resource
    protected Logger logger = Logger.NULL;
    private final Iterable<String> defaultRegions;
    private final Iterable<String> regions;

    @Inject
    BindRegionToXmlPayload(@Named(value="jclouds.aws.default_regions") String defaultRegions, @Named(value="jclouds.aws.regions") String regions) {
        this.defaultRegions = Splitter.on((char)',').split((CharSequence)defaultRegions);
        this.regions = Splitter.on((char)',').split((CharSequence)regions);
    }

    public void bindToRequest(HttpRequest request, Object input) {
        input = input == null ? Iterables.get(this.defaultRegions, (int)0) : input;
        Preconditions.checkArgument((boolean)(input instanceof String), (Object)"this binder is only valid for Region!");
        String constraint = (String)input;
        String value = null;
        if (Iterables.contains(this.defaultRegions, (Object)constraint)) {
            return;
        }
        if (Iterables.contains(this.regions, (Object)constraint)) {
            value = constraint;
        } else if (constraint.equals("eu-west-1")) {
            value = "EU";
        } else {
            this.logger.warn("region %s not in %s ", new Object[]{constraint, this.regions});
            value = constraint;
        }
        String payload = String.format("<CreateBucketConfiguration><LocationConstraint>%s</LocationConstraint></CreateBucketConfiguration>", value);
        super.bindToRequest(request, (Object)payload);
        request.getPayload().getContentMetadata().setContentType("text/xml");
    }
}

