/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.InputSupplier;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.crypto.Mac;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.aws.s3.Bucket;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.io.InputSuppliers;
import org.jclouds.logging.Logger;
import org.jclouds.rest.RequestSigner;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.util.Patterns;
import org.jclouds.util.Utils;

@Singleton
public class RequestAuthorizeSignature
implements HttpRequestFilter,
RequestSigner {
    private final String[] firstHeadersToSign = new String[]{"Date"};
    public static Set<String> SPECIAL_QUERIES = ImmutableSet.of((Object)"acl", (Object)"torrent", (Object)"logging", (Object)"location", (Object)"requestPayment");
    private final SignatureWire signatureWire;
    private final String accessKey;
    private final String secretKey;
    private final Provider<String> timeStampProvider;
    private final Crypto crypto;
    private final HttpUtils utils;
    @Resource
    @Named(value="jclouds.signature")
    Logger signatureLog = Logger.NULL;
    private final String authTag;
    private final String headerTag;
    private final String servicePath;
    private final boolean isVhostStyle;

    @Inject
    public RequestAuthorizeSignature(SignatureWire signatureWire, @Named(value="jclouds.aws.auth.tag") String authTag, @Named(value="jclouds.s3.virtual-host-buckets") boolean isVhostStyle, @Named(value="jclouds.s3.service-path") String servicePath, @Named(value="jclouds.aws.header.tag") String headerTag, @Named(value="jclouds.identity") String accessKey, @Named(value="jclouds.credential") String secretKey, @TimeStamp Provider<String> timeStampProvider, Crypto crypto, HttpUtils utils) {
        this.isVhostStyle = isVhostStyle;
        this.servicePath = servicePath;
        this.headerTag = headerTag;
        this.authTag = authTag;
        this.signatureWire = signatureWire;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.timeStampProvider = timeStampProvider;
        this.crypto = crypto;
        this.utils = utils;
    }

    public void filter(HttpRequest request) throws HttpException {
        this.replaceDateHeader(request);
        String toSign = this.createStringToSign(request);
        this.calculateAndReplaceAuthHeader(request, toSign);
        this.utils.logRequest(this.signatureLog, request, "<<");
    }

    public String createStringToSign(HttpRequest request) {
        this.utils.logRequest(this.signatureLog, request, ">>");
        StringBuilder buffer = new StringBuilder();
        this.appendMethod(request, buffer);
        this.appendPayloadMetadata(request, buffer);
        this.appendHttpHeaders(request, buffer);
        this.appendAmzHeaders(request, buffer);
        if (this.isVhostStyle) {
            this.appendBucketName(request, buffer);
        }
        this.appendUriPath(request, buffer);
        if (this.signatureWire.enabled()) {
            this.signatureWire.output((Object)buffer.toString());
        }
        return buffer.toString();
    }

    void calculateAndReplaceAuthHeader(HttpRequest request, String toSign) throws HttpException {
        String signature = this.sign(toSign);
        if (this.signatureWire.enabled()) {
            this.signatureWire.input(Utils.toInputStream((String)signature));
        }
        request.getHeaders().replaceValues((Object)"Authorization", Collections.singletonList(this.authTag + " " + this.accessKey + ":" + signature));
    }

    public String sign(String toSign) {
        String signature;
        try {
            signature = CryptoStreams.base64((byte[])CryptoStreams.mac((InputSupplier)InputSuppliers.of((String)toSign), (Mac)this.crypto.hmacSHA1(this.secretKey.getBytes())));
        }
        catch (Exception e) {
            throw new HttpException("error signing request", (Throwable)e);
        }
        return signature;
    }

    void appendMethod(HttpRequest request, StringBuilder toSign) {
        toSign.append(request.getMethod()).append("\n");
    }

    void replaceDateHeader(HttpRequest request) {
        request.getHeaders().replaceValues((Object)"Date", Collections.singletonList(this.timeStampProvider.get()));
    }

    void appendAmzHeaders(HttpRequest request, StringBuilder toSign) {
        TreeSet headers = new TreeSet(request.getHeaders().keySet());
        for (String header : headers) {
            if (!header.startsWith("x-" + this.headerTag + "-")) continue;
            toSign.append(header.toLowerCase()).append(":");
            for (String value : request.getHeaders().get((Object)header)) {
                toSign.append(Utils.replaceAll((String)value, (Pattern)Patterns.NEWLINE_PATTERN, (String)"")).append(",");
            }
            toSign.deleteCharAt(toSign.lastIndexOf(","));
            toSign.append("\n");
        }
    }

    void appendPayloadMetadata(HttpRequest request, StringBuilder buffer) {
        buffer.append(this.utils.valueOrEmpty(request.getPayload() == null ? null : request.getPayload().getContentMetadata().getContentMD5())).append("\n");
        buffer.append(this.utils.valueOrEmpty(request.getPayload() == null ? null : request.getPayload().getContentMetadata().getContentType())).append("\n");
    }

    void appendHttpHeaders(HttpRequest request, StringBuilder toSign) {
        for (String header : this.firstHeadersToSign) {
            toSign.append(this.valueOrEmpty(request.getHeaders().get((Object)header))).append("\n");
        }
    }

    @VisibleForTesting
    void appendBucketName(HttpRequest req, StringBuilder toSign) {
        Preconditions.checkArgument((boolean)(req instanceof GeneratedHttpRequest), (Object)"this should be a generated http request");
        GeneratedHttpRequest request = (GeneratedHttpRequest)GeneratedHttpRequest.class.cast(req);
        String bucketName = null;
        for (int i = 0; i < request.getJavaMethod().getParameterAnnotations().length; ++i) {
            if (!Iterables.any(Arrays.asList(request.getJavaMethod().getParameterAnnotations()[i]), (Predicate)new Predicate<Annotation>(){

                public boolean apply(Annotation input) {
                    return input.annotationType().equals(Bucket.class);
                }
            })) continue;
            bucketName = (String)request.getArgs()[i];
            break;
        }
        if (bucketName != null) {
            toSign.append(this.servicePath).append(bucketName);
        }
    }

    @VisibleForTesting
    void appendUriPath(HttpRequest request, StringBuilder toSign) {
        toSign.append(request.getEndpoint().getRawPath());
        if (request.getEndpoint().getQuery() != null) {
            String[] params;
            StringBuilder paramsToSign = new StringBuilder("?");
            for (String param : params = request.getEndpoint().getQuery().split("&")) {
                String[] paramNameAndValue = param.split("=");
                if (!SPECIAL_QUERIES.contains(paramNameAndValue[0])) continue;
                paramsToSign.append(paramNameAndValue[0]);
            }
            if (paramsToSign.length() > 1) {
                toSign.append((CharSequence)paramsToSign);
            }
        }
    }

    private String valueOrEmpty(Collection<String> collection) {
        return collection != null && collection.size() >= 1 ? collection.iterator().next() : "";
    }
}

