/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.domain.internal;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.jclouds.aws.s3.domain.CanonicalUser;
import org.jclouds.aws.s3.domain.MutableObjectMetadata;
import org.jclouds.aws.s3.domain.ObjectMetadata;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.payloads.BaseMutableContentMetadata;

public class MutableObjectMetadataImpl
implements Serializable,
MutableObjectMetadata {
    private static final long serialVersionUID = -4648755473986695062L;
    private String key;
    private Date lastModified;
    private String eTag;
    private CanonicalUser owner;
    private ObjectMetadata.StorageClass storageClass;
    private String cacheControl;
    private Map<String, String> userMetadata = Maps.newHashMap();
    private MutableContentMetadata contentMetadata;

    public MutableObjectMetadataImpl() {
        this.storageClass = ObjectMetadata.StorageClass.STANDARD;
        this.contentMetadata = new BaseMutableContentMetadata();
    }

    public MutableObjectMetadataImpl(ObjectMetadata from) {
        this.storageClass = ObjectMetadata.StorageClass.STANDARD;
        this.contentMetadata = new BaseMutableContentMetadata();
        HttpUtils.copy((ContentMetadata)from.getContentMetadata(), (MutableContentMetadata)this.contentMetadata);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public CanonicalUser getOwner() {
        return this.owner;
    }

    @Override
    public ObjectMetadata.StorageClass getStorageClass() {
        return this.storageClass;
    }

    @Override
    public String getCacheControl() {
        return this.cacheControl;
    }

    @Override
    public Date getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getETag() {
        return this.eTag;
    }

    @Override
    public int compareTo(ObjectMetadata o) {
        return this == o ? 0 : this.getKey().compareTo(o.getKey());
    }

    @Override
    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    @Override
    public void setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
    }

    @Override
    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    public void setOwner(CanonicalUser owner) {
        this.owner = owner;
    }

    @Override
    public void setStorageClass(ObjectMetadata.StorageClass storageClass) {
        this.storageClass = storageClass;
    }

    @Override
    public void setUserMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
    }

    @Override
    public MutableContentMetadata getContentMetadata() {
        return this.contentMetadata;
    }

    @Override
    public void setContentMetadata(MutableContentMetadata contentMetadata) {
        this.contentMetadata = contentMetadata;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cacheControl == null ? 0 : this.cacheControl.hashCode());
        result = 31 * result + (this.contentMetadata == null ? 0 : this.contentMetadata.hashCode());
        result = 31 * result + (this.eTag == null ? 0 : this.eTag.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.lastModified == null ? 0 : this.lastModified.hashCode());
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        result = 31 * result + (this.storageClass == null ? 0 : this.storageClass.hashCode());
        result = 31 * result + (this.userMetadata == null ? 0 : ((Object)this.userMetadata).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutableObjectMetadataImpl other = (MutableObjectMetadataImpl)obj;
        if (this.cacheControl == null ? other.cacheControl != null : !this.cacheControl.equals(other.cacheControl)) {
            return false;
        }
        if (this.contentMetadata == null ? other.contentMetadata != null : !this.contentMetadata.equals(other.contentMetadata)) {
            return false;
        }
        if (this.eTag == null ? other.eTag != null : !this.eTag.equals(other.eTag)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.lastModified == null ? other.lastModified != null : !this.lastModified.equals(other.lastModified)) {
            return false;
        }
        if (this.owner == null ? other.owner != null : !this.owner.equals(other.owner)) {
            return false;
        }
        if (this.storageClass == null ? other.storageClass != null : !this.storageClass.equals((Object)other.storageClass)) {
            return false;
        }
        return !(this.userMetadata == null ? other.userMetadata != null : !((Object)this.userMetadata).equals(other.userMetadata));
    }

    public String toString() {
        return "[key=" + this.key + ", cacheControl=" + this.cacheControl + ", contentMetadata=" + this.contentMetadata + ", eTag=" + this.eTag + ", lastModified=" + this.lastModified + ", owner=" + this.owner + ", storageClass=" + (Object)((Object)this.storageClass) + ", userMetadata=" + this.userMetadata + "]";
    }
}

