/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.domain.internal;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.jclouds.aws.s3.domain.CanonicalUser;
import org.jclouds.aws.s3.domain.ObjectMetadata;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.payloads.BaseImmutableContentMetadata;

public class BucketListObjectMetadata
implements Serializable,
ObjectMetadata {
    private static final long serialVersionUID = -4415449798024051115L;
    private final String key;
    private final Date lastModified;
    private final String eTag;
    private final CanonicalUser owner;
    private final ObjectMetadata.StorageClass storageClass;
    private final String cacheControl;
    private final Map<String, String> userMetadata;
    private final ContentMetadata contentMetadata;

    public BucketListObjectMetadata(String key, Date lastModified, String eTag, byte[] md5, long contentLength, CanonicalUser owner, ObjectMetadata.StorageClass storageClass) {
        this.key = key;
        this.lastModified = lastModified;
        this.eTag = eTag;
        this.owner = owner;
        this.contentMetadata = new BaseImmutableContentMetadata(null, Long.valueOf(contentLength), md5, null, null, null);
        this.storageClass = storageClass;
        this.cacheControl = null;
        this.userMetadata = Maps.newHashMap();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public CanonicalUser getOwner() {
        return this.owner;
    }

    @Override
    public ObjectMetadata.StorageClass getStorageClass() {
        return this.storageClass;
    }

    @Override
    public String getCacheControl() {
        return this.cacheControl;
    }

    @Override
    public Date getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getETag() {
        return this.eTag;
    }

    @Override
    public int compareTo(ObjectMetadata o) {
        return this == o ? 0 : this.getKey().compareTo(o.getKey());
    }

    @Override
    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    @Override
    public ContentMetadata getContentMetadata() {
        return this.contentMetadata;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cacheControl == null ? 0 : this.cacheControl.hashCode());
        result = 31 * result + (this.contentMetadata == null ? 0 : this.contentMetadata.hashCode());
        result = 31 * result + (this.eTag == null ? 0 : this.eTag.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.lastModified == null ? 0 : this.lastModified.hashCode());
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        result = 31 * result + (this.storageClass == null ? 0 : this.storageClass.hashCode());
        result = 31 * result + (this.userMetadata == null ? 0 : ((Object)this.userMetadata).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BucketListObjectMetadata other = (BucketListObjectMetadata)obj;
        if (this.cacheControl == null ? other.cacheControl != null : !this.cacheControl.equals(other.cacheControl)) {
            return false;
        }
        if (this.contentMetadata == null ? other.contentMetadata != null : !this.contentMetadata.equals(other.contentMetadata)) {
            return false;
        }
        if (this.eTag == null ? other.eTag != null : !this.eTag.equals(other.eTag)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.lastModified == null ? other.lastModified != null : !this.lastModified.equals(other.lastModified)) {
            return false;
        }
        if (this.owner == null ? other.owner != null : !this.owner.equals(other.owner)) {
            return false;
        }
        if (this.storageClass == null ? other.storageClass != null : !this.storageClass.equals((Object)other.storageClass)) {
            return false;
        }
        return !(this.userMetadata == null ? other.userMetadata != null : !((Object)this.userMetadata).equals(other.userMetadata));
    }
}

