/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.domain;

import com.google.common.base.CaseFormat;

public enum Payer {
    REQUESTER,
    BUCKET_OWNER,
    UNRECOGNIZED;


    public String value() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
    }

    public static Payer fromValue(String payer) {
        try {
            return Payer.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, payer));
        }
        catch (IllegalArgumentException e) {
            return UNRECOGNIZED;
        }
    }
}

