/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.domain;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.aws.s3.domain.AccessControlList;

public class BucketLogging {
    private final String targetBucket;
    private final String targetPrefix;
    private final Set<AccessControlList.Grant> targetGrants = Sets.newHashSet();

    public BucketLogging(String targetBucket, String targetPrefix, Iterable<AccessControlList.Grant> targetGrants) {
        this.targetBucket = targetBucket;
        this.targetPrefix = targetPrefix;
        Iterables.addAll(this.targetGrants, targetGrants);
    }

    public BucketLogging(String targetBucket, String targetPrefix) {
        this.targetBucket = targetBucket;
        this.targetPrefix = targetPrefix;
    }

    public Set<AccessControlList.Grant> getTargetGrants() {
        return this.targetGrants;
    }

    public String getTargetBucket() {
        return this.targetBucket;
    }

    public String getTargetPrefix() {
        return this.targetPrefix;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.targetBucket == null ? 0 : this.targetBucket.hashCode());
        result = 31 * result + (this.targetGrants == null ? 0 : ((Object)this.targetGrants).hashCode());
        result = 31 * result + (this.targetPrefix == null ? 0 : this.targetPrefix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BucketLogging other = (BucketLogging)obj;
        if (this.targetBucket == null ? other.targetBucket != null : !this.targetBucket.equals(other.targetBucket)) {
            return false;
        }
        if (this.targetGrants == null ? other.targetGrants != null : !((Object)this.targetGrants).equals(other.targetGrants)) {
            return false;
        }
        return !(this.targetPrefix == null ? other.targetPrefix != null : !this.targetPrefix.equals(other.targetPrefix));
    }

    public String toString() {
        return "BucketLogging [targetBucket=" + this.targetBucket + ", targetGrants=" + this.targetGrants + ", targetPrefix=" + this.targetPrefix + "]";
    }
}

