/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.domain;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jclouds.aws.s3.domain.CannedAccessPolicy;
import org.jclouds.aws.s3.domain.CanonicalUser;

public class AccessControlList {
    private CanonicalUser owner;
    private final List<Grant> grants = new ArrayList<Grant>();

    public void setOwner(CanonicalUser owner) {
        this.owner = owner;
    }

    public CanonicalUser getOwner() {
        return this.owner;
    }

    public List<Grant> getGrants() {
        return Collections.unmodifiableList(this.grants);
    }

    public Set<Grantee> getGrantees() {
        TreeSet<Grantee> grantees = new TreeSet<Grantee>();
        for (Grant grant : this.getGrants()) {
            grantees.add(grant.getGrantee());
        }
        return Collections.unmodifiableSet(grantees);
    }

    public AccessControlList addPermission(Grantee grantee, Permission permission) {
        Grant grant = new Grant(grantee, permission);
        this.grants.add(grant);
        return this;
    }

    public AccessControlList addPermission(GroupGranteeURI groupGranteeURI, Permission permission) {
        return this.addPermission(new GroupGrantee(groupGranteeURI), permission);
    }

    public AccessControlList revokePermission(Grantee grantee, Permission permission) {
        Collection<Grant> grantsForGrantee = this.findGrantsForGrantee(grantee.getIdentifier());
        for (Grant grant : grantsForGrantee) {
            if (!grant.getPermission().equals((Object)permission)) continue;
            this.grants.remove(grant);
        }
        return this;
    }

    public AccessControlList revokePermission(GroupGranteeURI groupGranteeURI, Permission permission) {
        return this.revokePermission(new GroupGrantee(groupGranteeURI), permission);
    }

    public AccessControlList revokeAllPermissions(Grantee grantee) {
        Collection<Grant> grantsForGrantee = this.findGrantsForGrantee(grantee.getIdentifier());
        this.grants.removeAll(grantsForGrantee);
        return this;
    }

    public Collection<Permission> getPermissions(String granteeId) {
        Collection<Grant> grantsForGrantee = this.findGrantsForGrantee(granteeId);
        return Collections2.transform(grantsForGrantee, (Function)new Function<Grant, Permission>(){

            public Permission apply(Grant g) {
                return g.getPermission();
            }
        });
    }

    public Collection<Permission> getPermissions(Grantee grantee) {
        return this.getPermissions(grantee.getIdentifier());
    }

    public Collection<Permission> getPermissions(GroupGranteeURI granteeURI) {
        return this.getPermissions(granteeURI.getIdentifier());
    }

    public boolean hasPermission(String granteeId, Permission permission) {
        return this.getPermissions(granteeId).contains((Object)permission);
    }

    public boolean hasPermission(Grantee grantee, Permission permission) {
        return this.hasPermission(grantee.getIdentifier(), permission);
    }

    public boolean hasPermission(GroupGranteeURI granteeURI, Permission permission) {
        return this.getPermissions(granteeURI.getIdentifier()).contains((Object)permission);
    }

    protected Collection<Grant> findGrantsForGrantee(final String granteeId) {
        return Collections2.filter(this.grants, (Predicate)new Predicate<Grant>(){

            public boolean apply(Grant g) {
                return g.getGrantee().getIdentifier().equals(granteeId);
            }
        });
    }

    public static AccessControlList fromCannedAccessPolicy(CannedAccessPolicy cannedAP, String ownerId) {
        AccessControlList acl = new AccessControlList();
        acl.setOwner(new CanonicalUser(ownerId));
        acl.addPermission(new CanonicalUserGrantee(ownerId), Permission.FULL_CONTROL);
        if (CannedAccessPolicy.PRIVATE != cannedAP) {
            if (CannedAccessPolicy.AUTHENTICATED_READ == cannedAP) {
                acl.addPermission(GroupGranteeURI.AUTHENTICATED_USERS, Permission.READ);
            } else if (CannedAccessPolicy.PUBLIC_READ == cannedAP) {
                acl.addPermission(GroupGranteeURI.ALL_USERS, Permission.READ);
            } else if (CannedAccessPolicy.PUBLIC_READ_WRITE == cannedAP) {
                acl.addPermission(GroupGranteeURI.ALL_USERS, Permission.READ);
                acl.addPermission(GroupGranteeURI.ALL_USERS, Permission.WRITE);
            }
        }
        return acl;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AccessControlList");
        sb.append("{owner=").append(this.owner);
        sb.append(", grants=").append(this.grants);
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.grants == null ? 0 : ((Object)this.grants).hashCode());
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessControlList other = (AccessControlList)obj;
        if (this.grants == null ? other.grants != null : !((Object)this.grants).equals(other.grants)) {
            return false;
        }
        return !(this.owner == null ? other.owner != null : !this.owner.equals(other.owner));
    }

    public static class GroupGrantee
    extends Grantee {
        public GroupGrantee(GroupGranteeURI groupURI) {
            super(groupURI.getIdentifier());
        }
    }

    public static enum GroupGranteeURI {
        ALL_USERS("http://acs.amazonaws.com/groups/global/AllUsers"),
        AUTHENTICATED_USERS("http://acs.amazonaws.com/groups/global/AuthenticatedUsers"),
        LOG_DELIVERY("http://acs.amazonaws.com/groups/s3/LogDelivery");

        private final String uri;

        private GroupGranteeURI(String uri) {
            this.uri = uri;
        }

        public String getIdentifier() {
            return this.uri;
        }

        public static GroupGranteeURI fromURI(String uri) {
            if (GroupGranteeURI.ALL_USERS.uri.equals(uri)) {
                return ALL_USERS;
            }
            if (GroupGranteeURI.AUTHENTICATED_USERS.uri.equals(uri)) {
                return AUTHENTICATED_USERS;
            }
            if (GroupGranteeURI.LOG_DELIVERY.uri.equals(uri)) {
                return LOG_DELIVERY;
            }
            throw new IllegalArgumentException("No GroupGranteeURI constant matches " + uri);
        }
    }

    public static class CanonicalUserGrantee
    extends Grantee {
        private final String displayName;

        public CanonicalUserGrantee(String id, String displayName) {
            super(id);
            this.displayName = displayName;
        }

        public CanonicalUserGrantee(String id) {
            this(id, null);
        }

        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("CanonicalUserGrantee");
            sb.append("{displayName='").append(this.displayName).append('\'');
            sb.append(", identifier='").append(this.getIdentifier()).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    public static class EmailAddressGrantee
    extends Grantee {
        public EmailAddressGrantee(String emailAddress) {
            super(emailAddress);
        }

        public String getEmailAddress() {
            return this.getIdentifier();
        }
    }

    public static abstract class Grantee
    implements Comparable<Grantee> {
        private final String identifier;

        protected Grantee(String identifier) {
            this.identifier = identifier;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Grantee");
            sb.append("{identifier='").append(this.identifier).append('\'');
            sb.append('}');
            return sb.toString();
        }

        @Override
        public int compareTo(Grantee o) {
            return this == o ? 0 : this.getIdentifier().compareTo(o.getIdentifier());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Grantee other = (Grantee)obj;
            return !(this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier));
        }
    }

    public static class Grant
    implements Comparable<Grant> {
        private Grantee grantee;
        private final Permission permission;

        public Grant(Grantee grantee, Permission permission) {
            this.grantee = grantee;
            this.permission = permission;
        }

        public Grantee getGrantee() {
            return this.grantee;
        }

        @VisibleForTesting
        public void setGrantee(Grantee grantee) {
            this.grantee = grantee;
        }

        public Permission getPermission() {
            return this.permission;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Grant");
            sb.append("{grantee=").append(this.grantee);
            sb.append(", permission=").append((Object)this.permission);
            sb.append('}');
            return sb.toString();
        }

        @Override
        public int compareTo(Grant o) {
            if (this == o) {
                return 0;
            }
            String myGranteeAndPermission = this.grantee.getIdentifier() + "\n" + (Object)((Object)this.permission);
            String otherGranteeAndPermission = o.grantee.getIdentifier() + "\n" + (Object)((Object)o.permission);
            return myGranteeAndPermission.compareTo(otherGranteeAndPermission);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.grantee == null ? 0 : this.grantee.hashCode());
            result = 31 * result + (this.permission == null ? 0 : this.permission.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Grant other = (Grant)obj;
            if (this.grantee == null ? other.grantee != null : !this.grantee.equals(other.grantee)) {
                return false;
            }
            return !(this.permission == null ? other.permission != null : !this.permission.equals((Object)other.permission));
        }
    }

    public static enum Permission {
        READ,
        WRITE,
        READ_ACP,
        WRITE_ACP,
        FULL_CONTROL;

    }
}

