/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.config;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.config.AWSRestClientModule;
import org.jclouds.aws.s3.S3AsyncClient;
import org.jclouds.aws.s3.S3Client;
import org.jclouds.aws.s3.config.S3ObjectModule;
import org.jclouds.aws.s3.config.S3ParserModule;
import org.jclouds.aws.s3.filters.RequestAuthorizeSignature;
import org.jclouds.date.DateService;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.RequiresHttp;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.RequestSigner;

@ConfiguresRestClient
@RequiresHttp
public class S3RestClientModule
extends AWSRestClientModule<S3Client, S3AsyncClient> {
    public S3RestClientModule() {
        super(S3Client.class, S3AsyncClient.class);
    }

    protected void configure() {
        this.install((Module)new S3ObjectModule());
        this.install((Module)new S3ParserModule());
        this.bind(RequestAuthorizeSignature.class).in(Scopes.SINGLETON);
        super.configure();
    }

    @Provides
    @Singleton
    protected RequestSigner provideRequestSigner(RequestAuthorizeSignature in) {
        return in;
    }

    @Provides
    @TimeStamp
    protected String provideTimeStamp(@TimeStamp Supplier<String> cache) {
        return (String)cache.get();
    }

    @Provides
    @TimeStamp
    @Singleton
    protected Supplier<String> provideTimeStampCache(@Named(value="jclouds.session-interval") long seconds, final DateService dateService) {
        return Suppliers.memoizeWithExpiration((Supplier)new Supplier<String>(){

            public String get() {
                return dateService.rfc822DateFormat();
            }
        }, (long)seconds, (TimeUnit)TimeUnit.SECONDS);
    }
}

