/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.config;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jclouds.aws.s3.domain.MutableObjectMetadata;
import org.jclouds.aws.s3.domain.S3Object;
import org.jclouds.aws.s3.domain.internal.S3ObjectImpl;
import org.jclouds.blobstore.config.BlobStoreObjectModule;

public class S3ObjectModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new BlobStoreObjectModule());
        this.bind(S3Object.Factory.class).to(S3ObjectFactory.class).asEagerSingleton();
    }

    @Provides
    S3Object provideS3Object(S3Object.Factory factory) {
        return factory.create(null);
    }

    private static class S3ObjectFactory
    implements S3Object.Factory {
        @Inject
        Provider<MutableObjectMetadata> metadataProvider;

        private S3ObjectFactory() {
        }

        @Override
        public S3Object create(MutableObjectMetadata metadata) {
            return new S3ObjectImpl(metadata != null ? metadata : (MutableObjectMetadata)this.metadataProvider.get());
        }
    }
}

