/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.blobstore.functions;

import com.google.common.base.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.s3.domain.ObjectMetadata;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.blobstore.strategy.IfDirectoryReturnNameStrategy;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.MutableContentMetadata;

@Singleton
public class ObjectToBlobMetadata
implements Function<ObjectMetadata, MutableBlobMetadata> {
    private final IfDirectoryReturnNameStrategy ifDirectoryReturnName;

    @Inject
    public ObjectToBlobMetadata(IfDirectoryReturnNameStrategy ifDirectoryReturnName) {
        this.ifDirectoryReturnName = ifDirectoryReturnName;
    }

    public MutableBlobMetadata apply(ObjectMetadata from) {
        if (from == null) {
            return null;
        }
        MutableBlobMetadataImpl to = new MutableBlobMetadataImpl();
        HttpUtils.copy((ContentMetadata)from.getContentMetadata(), (MutableContentMetadata)to.getContentMetadata());
        to.setETag(from.getETag());
        to.setName(from.getKey());
        to.setLastModified(from.getLastModified());
        to.setUserMetadata(from.getUserMetadata());
        String directoryName = this.ifDirectoryReturnName.execute((StorageMetadata)to);
        if (directoryName != null) {
            to.setName(directoryName);
            to.setType((Enum)StorageType.RELATIVE_PATH);
        } else {
            to.setType((Enum)StorageType.BLOB);
        }
        return to;
    }
}

