/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.s3.S3Client;
import org.jclouds.aws.s3.domain.BucketMetadata;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableStorageMetadataImpl;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;

@Singleton
public class BucketToResourceMetadata
implements Function<BucketMetadata, StorageMetadata> {
    private final S3Client client;
    private final Location onlyLocation;
    private final Supplier<Set<? extends Location>> locations;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    BucketToResourceMetadata(S3Client client, @Memoized Supplier<Set<? extends Location>> locations) {
        this.client = client;
        this.onlyLocation = ((Set)locations.get()).size() == 1 ? (Location)Iterables.get((Iterable)((Iterable)locations.get()), (int)0) : null;
        this.locations = locations;
    }

    public StorageMetadata apply(BucketMetadata from) {
        MutableStorageMetadataImpl to = new MutableStorageMetadataImpl();
        to.setName(from.getName());
        to.setType((Enum)StorageType.CONTAINER);
        to.setLocation(this.onlyLocation != null ? this.onlyLocation : this.getLocation(from));
        return to;
    }

    private Location getLocation(BucketMetadata from) {
        try {
            Set locations = (Set)this.locations.get();
            final String region = this.client.getBucketLocation(from.getName());
            assert (region != null) : String.format("could not get region for %s", from.getName());
            if (region != null) {
                try {
                    return (Location)Iterables.find((Iterable)locations, (Predicate)new Predicate<Location>(){

                        public boolean apply(Location input) {
                            return input.getId().equalsIgnoreCase(region.toString());
                        }
                    });
                }
                catch (NoSuchElementException e) {
                    this.logger.error("could not get location for region %s in %s", new Object[]{region, locations});
                }
            } else {
                this.logger.error("could not get region for %s", new Object[]{from.getName()});
            }
        }
        catch (ContainerNotFoundException e) {
            this.logger.error((Throwable)e, "could not get region for %s, as service suggests the bucket doesn't exist", new Object[]{from.getName()});
        }
        return null;
    }
}

