/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.blobstore.functions;

import com.google.common.base.Function;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.aws.s3.domain.MutableObjectMetadata;
import org.jclouds.aws.s3.domain.internal.MutableObjectMetadataImpl;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.MutableContentMetadata;

@Singleton
public class BlobToObjectMetadata
implements Function<BlobMetadata, MutableObjectMetadata> {
    public MutableObjectMetadata apply(BlobMetadata from) {
        if (from == null) {
            return null;
        }
        MutableObjectMetadataImpl to = new MutableObjectMetadataImpl();
        HttpUtils.copy((ContentMetadata)from.getContentMetadata(), (MutableContentMetadata)to.getContentMetadata());
        to.setETag(from.getETag());
        to.setKey(from.getName());
        to.setLastModified(from.getLastModified());
        if (from.getUserMetadata() != null) {
            for (Map.Entry entry : from.getUserMetadata().entrySet()) {
                to.getUserMetadata().put(((String)entry.getKey()).toLowerCase(), (String)entry.getValue());
            }
        }
        return to;
    }
}

