/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.blobstore.config;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.aws.Region;
import org.jclouds.aws.s3.S3AsyncClient;
import org.jclouds.aws.s3.S3Client;
import org.jclouds.aws.s3.blobstore.S3AsyncBlobStore;
import org.jclouds.aws.s3.blobstore.S3BlobRequestSigner;
import org.jclouds.aws.s3.blobstore.S3BlobStore;
import org.jclouds.aws.suppliers.DefaultLocationSupplier;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.attr.ConsistencyModel;
import org.jclouds.blobstore.config.BlobStoreMapModule;
import org.jclouds.blobstore.internal.BlobStoreContextImpl;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.internal.LocationImpl;
import org.jclouds.rest.annotations.Provider;

public class S3BlobStoreContextModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new BlobStoreMapModule());
        this.bind((TypeLiteral)new TypeLiteral<Supplier<Location>>(){}).to((TypeLiteral)new TypeLiteral<DefaultLocationSupplier>(){});
        this.bind(ConsistencyModel.class).toInstance((Object)ConsistencyModel.EVENTUAL);
        this.bind(AsyncBlobStore.class).to(S3AsyncBlobStore.class).in(Scopes.SINGLETON);
        this.bind(BlobStore.class).to(S3BlobStore.class).in(Scopes.SINGLETON);
        this.bind(BlobStoreContext.class).to((TypeLiteral)new TypeLiteral<BlobStoreContextImpl<S3Client, S3AsyncClient>>(){}).in(Scopes.SINGLETON);
        this.bind(BlobRequestSigner.class).to(S3BlobRequestSigner.class);
    }

    @Provides
    @Singleton
    @Memoized
    Supplier<Set<? extends Location>> provideLocations(@Region Set<String> regions, @Provider String providerName) {
        HashSet locations = Sets.newHashSet();
        LocationImpl s3 = new LocationImpl(LocationScope.PROVIDER, providerName, providerName, null);
        for (String zone : regions) {
            locations.add(new LocationImpl(LocationScope.REGION, zone.toString(), zone.toString(), (Location)s3));
        }
        return Suppliers.ofInstance((Object)locations);
    }
}

