/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.blobstore;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.aws.s3.S3Client;
import org.jclouds.aws.s3.blobstore.functions.BlobToObject;
import org.jclouds.aws.s3.blobstore.functions.BucketToResourceList;
import org.jclouds.aws.s3.blobstore.functions.BucketToResourceMetadata;
import org.jclouds.aws.s3.blobstore.functions.ContainerToBucketListOptions;
import org.jclouds.aws.s3.blobstore.functions.ObjectToBlob;
import org.jclouds.aws.s3.blobstore.functions.ObjectToBlobMetadata;
import org.jclouds.aws.s3.domain.BucketMetadata;
import org.jclouds.aws.s3.options.ListBucketOptions;
import org.jclouds.aws.s3.options.PutBucketOptions;
import org.jclouds.aws.s3.options.PutObjectOptions;
import org.jclouds.aws.s3.util.S3Utils;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.internal.BaseBlobStore;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.internal.FetchBlobMetadata;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.http.options.GetOptions;
import org.jclouds.util.Utils;

@Singleton
public class S3BlobStore
extends BaseBlobStore {
    private final S3Client sync;
    private final BucketToResourceMetadata bucket2ResourceMd;
    private final ContainerToBucketListOptions container2BucketListOptions;
    private final BucketToResourceList bucket2ResourceList;
    private final ObjectToBlob object2Blob;
    private final BlobToObject blob2Object;
    private final ObjectToBlobMetadata object2BlobMd;
    private final BlobToHttpGetOptions blob2ObjectGetOptions;
    private final Provider<FetchBlobMetadata> fetchBlobMetadataProvider;

    @Inject
    S3BlobStore(BlobStoreContext context, BlobUtils blobUtils, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, S3Client sync, BucketToResourceMetadata bucket2ResourceMd, ContainerToBucketListOptions container2BucketListOptions, BucketToResourceList bucket2ResourceList, ObjectToBlob object2Blob, BlobToHttpGetOptions blob2ObjectGetOptions, BlobToObject blob2Object, ObjectToBlobMetadata object2BlobMd, Provider<FetchBlobMetadata> fetchBlobMetadataProvider) {
        super(context, blobUtils, defaultLocation, locations);
        this.blob2ObjectGetOptions = (BlobToHttpGetOptions)Preconditions.checkNotNull((Object)blob2ObjectGetOptions, (Object)"blob2ObjectGetOptions");
        this.sync = (S3Client)Preconditions.checkNotNull((Object)sync, (Object)"sync");
        this.bucket2ResourceMd = (BucketToResourceMetadata)Preconditions.checkNotNull((Object)bucket2ResourceMd, (Object)"bucket2ResourceMd");
        this.container2BucketListOptions = (ContainerToBucketListOptions)Preconditions.checkNotNull((Object)container2BucketListOptions, (Object)"container2BucketListOptions");
        this.bucket2ResourceList = (BucketToResourceList)Preconditions.checkNotNull((Object)bucket2ResourceList, (Object)"bucket2ResourceList");
        this.object2Blob = (ObjectToBlob)Preconditions.checkNotNull((Object)object2Blob, (Object)"object2Blob");
        this.blob2Object = (BlobToObject)Preconditions.checkNotNull((Object)blob2Object, (Object)"blob2Object");
        this.object2BlobMd = (ObjectToBlobMetadata)Preconditions.checkNotNull((Object)object2BlobMd, (Object)"object2BlobMd");
        this.fetchBlobMetadataProvider = (Provider)Preconditions.checkNotNull(fetchBlobMetadataProvider, (Object)"fetchBlobMetadataProvider");
    }

    public PageSet<? extends StorageMetadata> list() {
        return new Function<Set<BucketMetadata>, PageSet<? extends StorageMetadata>>(){

            public PageSet<? extends StorageMetadata> apply(Set<BucketMetadata> from) {
                return new PageSetImpl(Iterables.transform(from, (Function)S3BlobStore.this.bucket2ResourceMd), null);
            }
        }.apply(this.sync.listOwnedBuckets());
    }

    public boolean containerExists(String container) {
        return this.sync.bucketExists(container);
    }

    public boolean createContainerInLocation(Location location, String container) {
        location = location != null ? location : (Location)this.defaultLocation.get();
        return this.sync.putBucketInRegion(location.getId(), container, new PutBucketOptions[0]);
    }

    public PageSet<? extends StorageMetadata> list(String container, ListContainerOptions options) {
        ListBucketOptions httpOptions = this.container2BucketListOptions.apply(options);
        PageSet list = this.bucket2ResourceList.apply(this.sync.listBucket(container, httpOptions));
        return options.isDetailed() ? ((FetchBlobMetadata)this.fetchBlobMetadataProvider.get()).setContainerName(container).apply(list) : list;
    }

    public void deleteContainer(String container) {
        this.clearAndDeleteContainer(container);
    }

    public void clearAndDeleteContainer(final String container) {
        try {
            if (!Utils.eventuallyTrue((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    S3BlobStore.this.clearContainer(container);
                    return S3BlobStore.this.sync.deleteBucketIfEmpty(container);
                }
            }, (long)30000L)) {
                throw new IllegalStateException(container + " still exists after deleting!");
            }
        }
        catch (InterruptedException e) {
            new IllegalStateException(container + " interrupted during deletion!", e);
        }
    }

    public boolean blobExists(String container, String key) {
        return this.sync.objectExists(container, key);
    }

    public BlobMetadata blobMetadata(String container, String key) {
        return this.object2BlobMd.apply(this.sync.headObject(container, key));
    }

    public Blob getBlob(String container, String key, org.jclouds.blobstore.options.GetOptions optionsList) {
        GetOptions httpOptions = this.blob2ObjectGetOptions.apply(optionsList);
        return this.object2Blob.apply(this.sync.getObject(container, key, httpOptions));
    }

    public String putBlob(String container, Blob blob) {
        return this.sync.putObject(container, this.blob2Object.apply(blob), new PutObjectOptions[0]);
    }

    public void removeBlob(String container, String key) {
        this.sync.deleteObject(container, key);
    }

    protected boolean deleteAndVerifyContainerGone(String container) {
        return S3Utils.deleteAndVerifyContainerGone(this.sync, container);
    }
}

