/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.binders;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.s3.blobstore.functions.ObjectToBlob;
import org.jclouds.aws.s3.domain.S3Object;
import org.jclouds.blobstore.binders.BindUserMetadataToHeadersWithPrefix;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindS3ObjectToPayload
implements Binder {
    private final BindUserMetadataToHeadersWithPrefix blobBinder;
    private final ObjectToBlob object2Blob;

    @Inject
    public BindS3ObjectToPayload(ObjectToBlob object2Blob, BindUserMetadataToHeadersWithPrefix blobBinder) {
        this.blobBinder = blobBinder;
        this.object2Blob = object2Blob;
    }

    public void bindToRequest(HttpRequest request, Object payload) {
        S3Object s3Object = (S3Object)payload;
        Preconditions.checkArgument((s3Object.getPayload().getContentMetadata().getContentLength() != null ? 1 : 0) != 0, (Object)"contentLength must be set, streaming not supported");
        Preconditions.checkArgument((s3Object.getPayload().getContentMetadata().getContentLength() <= 0x140000000L ? 1 : 0) != 0, (Object)"maximum size for put object is 5GB");
        this.blobBinder.bindToRequest(request, (Object)this.object2Blob.apply(s3Object));
        if (s3Object.getMetadata().getCacheControl() != null) {
            request.getHeaders().put((Object)"Cache-Control", (Object)s3Object.getMetadata().getCacheControl());
        }
    }
}

