/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.binders;

import com.google.common.base.Preconditions;
import javax.inject.Singleton;
import org.jclouds.aws.s3.domain.Payer;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindPayerToXmlPayload
implements Binder {
    public void bindToRequest(HttpRequest request, Object toBind) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)toBind, (Object)"toBind") instanceof Payer), (Object)"this binder is only valid for Payer!");
        String text = String.format("<RequestPaymentConfiguration xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\"><Payer>%s</Payer></RequestPaymentConfiguration>", ((Payer)((Object)toBind)).value());
        request.setPayload(text);
        request.getPayload().getContentMetadata().setContentType("text/xml");
    }
}

