/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.binders;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.aws.s3.S3AsyncClient;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpUtils;
import org.jclouds.rest.Binder;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.binders.BindAsHostPrefix;

@Singleton
public class BindAsHostPrefixIfConfigured
implements Binder {
    private final Provider<UriBuilder> uriBuilderProvider;
    private final BindAsHostPrefix bindAsHostPrefix;
    private final boolean isVhostStyle;
    private final String servicePath;

    @Inject
    public BindAsHostPrefixIfConfigured(BindAsHostPrefix bindAsHostPrefix, @Named(value="jclouds.s3.virtual-host-buckets") boolean isVhostStyle, @Named(value="jclouds.s3.service-path") String servicePath, Provider<UriBuilder> uriBuilderProvider) {
        this.bindAsHostPrefix = bindAsHostPrefix;
        this.isVhostStyle = isVhostStyle;
        this.servicePath = servicePath;
        this.uriBuilderProvider = uriBuilderProvider;
    }

    public void bindToRequest(HttpRequest request, Object payload) {
        if (this.isVhostStyle) {
            this.bindAsHostPrefix.bindToRequest(request, payload);
            request.getHeaders().replaceValues((Object)"Host", (Iterable)ImmutableSet.of((Object)request.getEndpoint().getHost()));
        } else {
            UriBuilder builder = ((UriBuilder)this.uriBuilderProvider.get()).uri(request.getEndpoint());
            StringBuilder path = new StringBuilder(HttpUtils.urlEncode((String)request.getEndpoint().getPath(), (char[])S3AsyncClient.class.getAnnotation(SkipEncoding.class).value()));
            int indexToInsert = path.indexOf(this.servicePath);
            indexToInsert = indexToInsert == -1 ? 0 : indexToInsert;
            path.insert(indexToInsert += this.servicePath.length(), "/" + payload.toString());
            builder.replacePath(path.toString());
            request.setEndpoint(builder.buildFromEncodedMap((Map)Maps.newHashMap()));
        }
    }
}

