/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3;

import com.google.common.base.Joiner;
import java.util.Properties;
import org.jclouds.PropertiesBuilder;

public class S3PropertiesBuilder
extends PropertiesBuilder {
    protected Properties defaultProperties() {
        Properties properties = super.defaultProperties();
        properties.setProperty("jclouds.api-version", "2006-03-01");
        properties.setProperty("jclouds.aws.auth.tag", "AWS");
        properties.setProperty("jclouds.aws.header.tag", "amz");
        properties.setProperty("jclouds.s3.service-path", "/");
        properties.setProperty("jclouds.s3.virtual-host-buckets", "true");
        properties.setProperty("jclouds.relax-hostname", "true");
        this.addEndpoints(properties);
        properties.setProperty("jclouds.blobstore.directorysuffix", "_$folder$");
        return properties;
    }

    protected Properties addEndpoints(Properties properties) {
        properties.setProperty("jclouds.aws.regions", Joiner.on((char)',').join((Object)"us-standard", (Object)"us-west-1", new Object[]{"EU", "ap-southeast-1"}));
        properties.setProperty("jclouds.aws.default_regions", "us-standard");
        properties.setProperty("jclouds.endpoint", "https://s3.amazonaws.com");
        properties.setProperty("jclouds.endpoint.us-standard", "https://s3.amazonaws.com");
        properties.setProperty("jclouds.endpoint.us-west-1", "https://s3-us-west-1.amazonaws.com");
        properties.setProperty("jclouds.endpoint.EU", "https://s3-eu-west-1.amazonaws.com");
        properties.setProperty("jclouds.endpoint.ap-southeast-1", "https://s3-ap-southeast-1.amazonaws.com");
        return properties;
    }

    public S3PropertiesBuilder(Properties properties) {
        super(properties);
    }

    public S3PropertiesBuilder() {
    }

    protected S3PropertiesBuilder withMetaPrefix(String prefix) {
        this.properties.setProperty("jclouds.blobstore.metaprefix", prefix);
        return this;
    }

    protected void setMetaPrefix() {
        if (this.properties.getProperty("jclouds.blobstore.metaprefix") == null) {
            this.properties.setProperty("jclouds.blobstore.metaprefix", String.format("x-%s-meta-", this.properties.getProperty("jclouds.aws.header.tag")));
        }
    }

    public Properties build() {
        this.setMetaPrefix();
        return super.build();
    }
}

