/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.handlers;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.aws.domain.AWSError;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.Utils;

@Singleton
public class ParseAWSErrorFromXmlContent
implements HttpErrorHandler {
    @Resource
    protected Logger logger = Logger.NULL;
    @VisibleForTesting
    final AWSUtils utils;

    @Inject
    ParseAWSErrorFromXmlContent(AWSUtils utils) {
        this.utils = utils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleError(HttpCommand command, HttpResponse response) {
        void var4_18;
        HttpRequest request = command.getRequest();
        Exception exception = null;
        try {
            void var4_6;
            AWSError error = null;
            String message = null;
            if (response.getPayload() != null) {
                String contentType = response.getPayload().getContentMetadata().getContentType();
                if (contentType != null && (contentType.indexOf("xml") != -1 || contentType.indexOf("unknown") != -1)) {
                    error = this.utils.parseAWSErrorFromContent(request, response);
                    if (error != null) {
                        message = error.getMessage();
                        AWSResponseException aWSResponseException = new AWSResponseException(command, response, error);
                    }
                } else {
                    try {
                        message = Utils.toStringAndClose((InputStream)response.getPayload().getInput());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
            String string = message = message != null ? message : String.format("%s -> %s", request.getRequestLine(), response.getStatusLine());
            if (var4_6 == null) {
                HttpResponseException httpResponseException = new HttpResponseException(command, response, message);
            }
            switch (response.getStatusCode()) {
                case 400: {
                    void var4_8;
                    if (error != null && error.getCode() != null && (error.getCode().endsWith(".NotFound") || error.getCode().endsWith(".Unknown"))) {
                        ResourceNotFoundException resourceNotFoundException = new ResourceNotFoundException(message, (Throwable)var4_8);
                        break;
                    }
                    if (error != null && error.getCode() != null && (error.getCode().equals("IncorrectState") || error.getCode().endsWith(".Duplicate")) || message != null && message.indexOf("already exists") != -1) {
                        IllegalStateException illegalStateException = new IllegalStateException(message, (Throwable)var4_8);
                        break;
                    }
                    if (error != null && error.getCode() != null && error.getCode().equals("AuthFailure")) {
                        AuthorizationException authorizationException = new AuthorizationException(command.getRequest(), message);
                        break;
                    }
                    if (message == null || message.indexOf("Failed to bind the following fields") == -1) break;
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(message, (Throwable)var4_8);
                    break;
                }
                case 401: 
                case 403: {
                    AuthorizationException authorizationException = new AuthorizationException(command.getRequest(), message);
                    break;
                }
                case 404: {
                    if (command.getRequest().getMethod().equals("DELETE")) break;
                    String container = request.getEndpoint().getHost();
                    String key = request.getEndpoint().getPath();
                    if (key == null || key.equals("/")) {
                        ContainerNotFoundException containerNotFoundException = new ContainerNotFoundException(container, message);
                        break;
                    }
                    KeyNotFoundException keyNotFoundException = new KeyNotFoundException(container, key, message);
                    break;
                }
                case 409: {
                    void var4_8;
                    IllegalStateException illegalStateException = new IllegalStateException(message, (Throwable)var4_8);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            HttpUtils.releasePayload((HttpResponse)response);
            command.setException(exception);
            throw throwable;
        }
        HttpUtils.releasePayload((HttpResponse)response);
        command.setException((Exception)var4_18);
    }
}

