/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.handlers;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.aws.domain.AWSError;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.http.handlers.RedirectionRetryHandler;
import org.jclouds.io.PayloadEnclosing;

@Singleton
public class AWSRedirectionRetryHandler
extends RedirectionRetryHandler {
    private final AWSUtils utils;

    @Inject
    public AWSRedirectionRetryHandler(Provider<UriBuilder> uriBuilderProvider, BackoffLimitedRetryHandler backoffHandler, AWSUtils utils) {
        super(uriBuilderProvider, backoffHandler);
        this.utils = utils;
    }

    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        if (response.getFirstHeaderOrNull("Location") == null && (response.getStatusCode() == 301 || response.getStatusCode() == 307)) {
            if (command.getRequest().getMethod() == "HEAD") {
                HttpUtils.changeToGETRequest((HttpRequest)command.getRequest());
                return true;
            }
            command.incrementRedirectCount();
            HttpUtils.closeClientButKeepContentStream((PayloadEnclosing)response);
            AWSError error = this.utils.parseAWSErrorFromContent(command.getRequest(), response);
            String host = error.getDetails().get("Endpoint");
            if (host != null) {
                if (host.equals(command.getRequest().getEndpoint().getHost())) {
                    return this.backoffHandler.shouldRetryRequest(command, response);
                }
                HttpUtils.changeSchemeHostAndPortTo((HttpRequest)command.getRequest(), (String)command.getRequest().getEndpoint().getScheme(), (String)host, (int)command.getRequest().getEndpoint().getPort(), (UriBuilder)((UriBuilder)this.uriBuilderProvider.get()));
                return true;
            }
            return false;
        }
        return super.shouldRetryRequest(command, response);
    }
}

