/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.io.InputSupplier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Resource;
import javax.crypto.Mac;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.io.InputSuppliers;
import org.jclouds.logging.Logger;
import org.jclouds.rest.RequestSigner;
import org.jclouds.util.Utils;

@Singleton
public class FormSigner
implements HttpRequestFilter,
RequestSigner {
    public static String[] mandatoryParametersForSignature = new String[]{"Action", "SignatureMethod", "SignatureVersion", "Version"};
    private final SignatureWire signatureWire;
    private final String accessKey;
    private final String secretKey;
    private final Provider<String> dateService;
    private final Crypto crypto;
    private final HttpUtils utils;
    @Resource
    @Named(value="jclouds.signature")
    private Logger signatureLog = Logger.NULL;

    @Inject
    public FormSigner(SignatureWire signatureWire, @Named(value="jclouds.identity") String accessKey, @Named(value="jclouds.credential") String secretKey, @TimeStamp Provider<String> dateService, Crypto crypto, HttpUtils utils) {
        this.signatureWire = signatureWire;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.dateService = dateService;
        this.crypto = crypto;
        this.utils = utils;
    }

    public void filter(HttpRequest request) throws HttpException {
        Preconditions.checkNotNull((Object)request.getFirstHeaderOrNull("Host"), (Object)"request is not ready to sign; host not present");
        Multimap decodedParams = HttpUtils.parseQueryToMap((String)request.getPayload().getRawContent().toString());
        this.addSigningParams((Multimap<String, String>)decodedParams);
        this.validateParams((Multimap<String, String>)decodedParams);
        String stringToSign = this.createStringToSign(request, (Multimap<String, String>)decodedParams);
        String signature = this.sign(stringToSign);
        this.addSignature((Multimap<String, String>)decodedParams, signature);
        this.setPayload(request, (Multimap<String, String>)decodedParams);
        this.utils.logRequest(this.signatureLog, request, "<<");
    }

    String[] sortForSigning(String queryLine) {
        String[] parts = queryLine.split("&");
        Arrays.sort(parts, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.startsWith("AWSAccessKeyId")) {
                    return -1;
                }
                return o1.compareTo(o2);
            }
        });
        return parts;
    }

    void setPayload(HttpRequest request, Multimap<String, String> decodedParams) {
        request.setPayload(HttpUtils.makeQueryLine(decodedParams, (Comparator)new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                if (o1.getKey().startsWith("Action") || o2.getKey().startsWith("AWSAccessKeyId")) {
                    return -1;
                }
                if (o1.getKey().startsWith("AWSAccessKeyId") || o2.getKey().startsWith("Action")) {
                    return 1;
                }
                return o1.getKey().compareTo(o2.getKey());
            }
        }, (char[])new char[0]));
        request.getPayload().getContentMetadata().setContentType("application/x-www-form-urlencoded");
    }

    @VisibleForTesting
    void validateParams(Multimap<String, String> params) {
        for (String parameter : mandatoryParametersForSignature) {
            Preconditions.checkState((boolean)params.containsKey((Object)parameter), (Object)("parameter " + parameter + " is required for signature"));
        }
    }

    @VisibleForTesting
    void addSignature(Multimap<String, String> params, String signature) {
        params.replaceValues((Object)"Signature", (Iterable)ImmutableList.of((Object)signature));
    }

    @VisibleForTesting
    public String sign(String stringToSign) {
        String signature;
        try {
            signature = CryptoStreams.base64((byte[])CryptoStreams.mac((InputSupplier)InputSuppliers.of((String)stringToSign), (Mac)this.crypto.hmacSHA256(this.secretKey.getBytes())));
            if (this.signatureWire.enabled()) {
                this.signatureWire.input(Utils.toInputStream((String)signature));
            }
        }
        catch (Exception e) {
            throw new HttpException("error signing request", (Throwable)e);
        }
        return signature;
    }

    @VisibleForTesting
    public String createStringToSign(HttpRequest request, Multimap<String, String> decodedParams) {
        this.utils.logRequest(this.signatureLog, request, ">>");
        StringBuilder stringToSign = new StringBuilder();
        stringToSign.append(request.getMethod()).append("\n");
        stringToSign.append(request.getFirstHeaderOrNull("Host").toLowerCase()).append("\n");
        stringToSign.append(request.getEndpoint().getPath()).append("\n");
        stringToSign.append(this.buildCanonicalizedString(decodedParams));
        if (this.signatureWire.enabled()) {
            this.signatureWire.output((Object)stringToSign.toString());
        }
        return stringToSign.toString();
    }

    @VisibleForTesting
    String buildCanonicalizedString(Multimap<String, String> decodedParams) {
        return HttpUtils.makeQueryLine(decodedParams, (Comparator)new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                if (o1.getKey().startsWith("AWSAccessKeyId")) {
                    return -1;
                }
                return o1.getKey().compareTo(o2.getKey());
            }
        }, (char[])new char[0]);
    }

    @VisibleForTesting
    void addSigningParams(Multimap<String, String> params) {
        params.replaceValues((Object)"SignatureMethod", (Iterable)ImmutableList.of((Object)"HmacSHA256"));
        params.replaceValues((Object)"SignatureVersion", (Iterable)ImmutableList.of((Object)"2"));
        params.replaceValues((Object)"Timestamp", (Iterable)ImmutableList.of((Object)this.dateService.get()));
        params.replaceValues((Object)"AWSAccessKeyId", (Iterable)ImmutableList.of((Object)this.accessKey));
        params.removeAll((Object)"Signature");
    }

    public String createStringToSign(HttpRequest input) {
        return this.createStringToSign(input, (Multimap<String, String>)HttpUtils.parseQueryToMap((String)input.getPayload().getRawContent().toString()));
    }
}

