/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.elb.xml;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.aws.Region;
import org.jclouds.aws.ec2.util.EC2Utils;
import org.jclouds.aws.elb.domain.LoadBalancer;
import org.jclouds.date.DateService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;
import org.xml.sax.Attributes;

public class DescribeLoadBalancersResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Set<LoadBalancer>> {
    @Inject
    protected DateService dateService;
    @Resource
    protected Logger logger = Logger.NULL;
    private Set<LoadBalancer> contents = Sets.newLinkedHashSet();
    private StringBuilder currentText = new StringBuilder();
    private final String defaultRegion;
    private final LoadBalancerListenerHandler listenerHandler;
    private boolean inListenerDescriptions = false;
    private boolean inInstances = false;
    private boolean inAppCookieStickinessPolicies = false;
    private boolean inLBCookieStickinessPolicies = false;
    private boolean inAvailabilityZones = false;
    private boolean inLoadBalancerDescriptions = false;
    private LoadBalancer elb;
    private LoadBalancer.AppCookieStickinessPolicy appCookieStickinessPolicy;
    private LoadBalancer.LBCookieStickinessPolicy lBCookieStickinessPolicy;

    @Inject
    public DescribeLoadBalancersResponseHandler(@Region String defaultRegion) {
        this.defaultRegion = defaultRegion;
        this.listenerHandler = new LoadBalancerListenerHandler();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equals("ListenerDescriptions") || this.inListenerDescriptions) {
            this.inListenerDescriptions = true;
        } else if (qName.equals("AppCookieStickinessPolicies")) {
            this.inAppCookieStickinessPolicies = true;
        } else if (qName.equals("LBCookieStickinessPolicies")) {
            this.inLBCookieStickinessPolicies = true;
        } else if (qName.equals("LoadBalancerDescriptions")) {
            this.inLoadBalancerDescriptions = true;
        } else if (qName.equals("Instances")) {
            this.inInstances = true;
        } else if (qName.equals("AvailabilityZones")) {
            this.inAvailabilityZones = true;
        }
        if (!(!qName.equals("member") || this.inListenerDescriptions || this.inAppCookieStickinessPolicies || this.inInstances || this.inLBCookieStickinessPolicies || this.inAvailabilityZones)) {
            this.elb = new LoadBalancer();
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (qName.equals("ListenerDescriptions")) {
            this.inListenerDescriptions = false;
        } else if (qName.equals("AppCookieStickinessPolicies")) {
            this.inAppCookieStickinessPolicies = false;
        } else if (qName.equals("LBCookieStickinessPolicies")) {
            this.inLBCookieStickinessPolicies = false;
        } else if (qName.equals("LoadBalancerDescriptions")) {
            this.inLoadBalancerDescriptions = false;
        } else if (qName.equals("Instances")) {
            this.inInstances = false;
        } else if (qName.equals("AvailabilityZones")) {
            this.inAvailabilityZones = false;
        }
        if (qName.equals("DNSName")) {
            this.elb.setDnsName(this.currentText.toString().trim());
        } else if (qName.equals("LoadBalancerName")) {
            this.elb.setName(this.currentText.toString().trim());
        } else if (qName.equals("InstanceId")) {
            this.elb.getInstanceIds().add(this.currentText.toString().trim());
        } else if (qName.equals("member")) {
            if (this.inAvailabilityZones) {
                this.elb.getAvailabilityZones().add(this.currentText.toString().trim());
            } else if (!(this.inListenerDescriptions || this.inAppCookieStickinessPolicies || this.inInstances || this.inLBCookieStickinessPolicies || this.inAvailabilityZones)) {
                try {
                    String region = EC2Utils.findRegionInArgsOrNull(this.getRequest());
                    if (region == null) {
                        region = this.defaultRegion;
                    }
                    this.elb.setRegion(region);
                    this.contents.add(this.elb);
                }
                catch (NullPointerException e) {
                    this.logger.warn((Throwable)e, "malformed load balancer: %s", new Object[]{localName});
                }
                this.elb = null;
            }
        }
        this.currentText = new StringBuilder();
    }

    public Set<LoadBalancer> getResult() {
        return this.contents;
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    public DescribeLoadBalancersResponseHandler setContext(HttpRequest request) {
        this.listenerHandler.setContext(request);
        super.setContext(request);
        return this;
    }

    public class LoadBalancerListenerHandler
    extends ParseSax.HandlerWithResult<Set<LoadBalancer.LoadBalancerListener>> {
        private Set<LoadBalancer.LoadBalancerListener> listeners = Sets.newHashSet();
        private StringBuilder currentText = new StringBuilder();
        private LoadBalancer.LoadBalancerListener listener;

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (qName.equals("member")) {
                this.listener = new LoadBalancer.LoadBalancerListener();
            }
        }

        public void endElement(String uri, String name, String qName) {
            if (qName.equals("Protocol")) {
                this.listener.setProtocol(this.currentText.toString().trim());
            } else if (qName.equals("LoadBalancerPort")) {
                this.listener.setLoadBalancerPort(Integer.parseInt(this.currentText.toString().trim()));
            } else if (qName.equals("InstancePort")) {
                this.listener.setInstancePort(Integer.parseInt(this.currentText.toString().trim()));
            } else if (qName.equals("member")) {
                this.listeners.add(this.listener);
            }
            this.currentText = new StringBuilder();
        }

        public Set<LoadBalancer.LoadBalancerListener> getResult() {
            return this.listeners;
        }

        public void characters(char[] ch, int start, int length) {
            this.currentText.append(ch, start, length);
        }
    }
}

