/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.elb.domain;

import java.util.HashSet;
import java.util.Set;

public class LoadBalancer
implements Comparable<LoadBalancer> {
    private String region;
    private String name;
    private Set<String> instanceIds;
    private Set<String> availabilityZones;
    private String dnsName;
    private AppCookieStickinessPolicy appCookieStickinessPolicy;
    private LBCookieStickinessPolicy lBCookieStickinessPolicy;
    private Set<LoadBalancerListener> loadBalancerListeners;

    public LoadBalancer() {
        this.instanceIds = new HashSet<String>();
        this.availabilityZones = new HashSet<String>();
        this.loadBalancerListeners = new HashSet<LoadBalancerListener>();
    }

    public LoadBalancer(String region, String name, Set<String> instanceIds, Set<String> availabilityZones, String dnsName) {
        this.region = region;
        this.name = name;
        this.instanceIds = instanceIds;
        this.availabilityZones = availabilityZones;
        this.dnsName = dnsName;
        this.loadBalancerListeners = new HashSet<LoadBalancerListener>();
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setInstanceIds(Set<String> instanceIds) {
        this.instanceIds = instanceIds;
    }

    public void setAvailabilityZones(Set<String> availabilityZones) {
        this.availabilityZones = availabilityZones;
    }

    public void setDnsName(String dnsName) {
        this.dnsName = dnsName;
    }

    public void setAppCookieStickinessPolicy(AppCookieStickinessPolicy appCookieStickinessPolicy) {
        this.appCookieStickinessPolicy = appCookieStickinessPolicy;
    }

    public void setlBCookieStickinessPolicy(LBCookieStickinessPolicy lBCookieStickinessPolicy) {
        this.lBCookieStickinessPolicy = lBCookieStickinessPolicy;
    }

    public void setLoadBalancerListeners(Set<LoadBalancerListener> loadBalancerListeners) {
        this.loadBalancerListeners = loadBalancerListeners;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getInstanceIds() {
        return this.instanceIds;
    }

    public Set<String> getAvailabilityZones() {
        return this.availabilityZones;
    }

    public String getDnsName() {
        return this.dnsName;
    }

    public AppCookieStickinessPolicy getAppCookieStickinessPolicy() {
        return this.appCookieStickinessPolicy;
    }

    public LBCookieStickinessPolicy getlBCookieStickinessPolicy() {
        return this.lBCookieStickinessPolicy;
    }

    public Set<LoadBalancerListener> getLoadBalancerListeners() {
        return this.loadBalancerListeners;
    }

    public String getRegion() {
        return this.region;
    }

    @Override
    public int compareTo(LoadBalancer that) {
        return this.name.compareTo(that.name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.appCookieStickinessPolicy == null ? 0 : this.appCookieStickinessPolicy.hashCode());
        result = 31 * result + (this.availabilityZones == null ? 0 : ((Object)this.availabilityZones).hashCode());
        result = 31 * result + (this.dnsName == null ? 0 : this.dnsName.hashCode());
        result = 31 * result + (this.instanceIds == null ? 0 : ((Object)this.instanceIds).hashCode());
        result = 31 * result + (this.lBCookieStickinessPolicy == null ? 0 : this.lBCookieStickinessPolicy.hashCode());
        result = 31 * result + (this.loadBalancerListeners == null ? 0 : ((Object)this.loadBalancerListeners).hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoadBalancer other = (LoadBalancer)obj;
        if (this.appCookieStickinessPolicy == null ? other.appCookieStickinessPolicy != null : !this.appCookieStickinessPolicy.equals(other.appCookieStickinessPolicy)) {
            return false;
        }
        if (this.availabilityZones == null ? other.availabilityZones != null : !((Object)this.availabilityZones).equals(other.availabilityZones)) {
            return false;
        }
        if (this.dnsName == null ? other.dnsName != null : !this.dnsName.equals(other.dnsName)) {
            return false;
        }
        if (this.instanceIds == null ? other.instanceIds != null : !((Object)this.instanceIds).equals(other.instanceIds)) {
            return false;
        }
        if (this.lBCookieStickinessPolicy == null ? other.lBCookieStickinessPolicy != null : !this.lBCookieStickinessPolicy.equals(other.lBCookieStickinessPolicy)) {
            return false;
        }
        if (this.loadBalancerListeners == null ? other.loadBalancerListeners != null : !((Object)this.loadBalancerListeners).equals(other.loadBalancerListeners)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.region == null ? other.region != null : !this.region.equals(other.region));
    }

    public static class LoadBalancerListener {
        private Set<String> policyNames;
        private Integer instancePort;
        private Integer loadBalancerPort;
        private String protocol;

        public LoadBalancerListener(Set<String> policyNames, Integer instancePort, Integer loadBalancerPort, String protocol) {
            this.policyNames = policyNames;
            this.instancePort = instancePort;
            this.loadBalancerPort = loadBalancerPort;
            this.protocol = protocol;
        }

        public LoadBalancerListener() {
        }

        public Set<String> getPolicyNames() {
            return this.policyNames;
        }

        public Integer getInstancePort() {
            return this.instancePort;
        }

        public Integer getLoadBalancerPort() {
            return this.loadBalancerPort;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setPolicyNames(Set<String> policyNames) {
            this.policyNames = policyNames;
        }

        public void setInstancePort(Integer instancePort) {
            this.instancePort = instancePort;
        }

        public void setLoadBalancerPort(Integer loadBalancerPort) {
            this.loadBalancerPort = loadBalancerPort;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.instancePort == null ? 0 : this.instancePort.hashCode());
            result = 31 * result + (this.loadBalancerPort == null ? 0 : this.loadBalancerPort.hashCode());
            result = 31 * result + (this.policyNames == null ? 0 : ((Object)this.policyNames).hashCode());
            result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LoadBalancerListener other = (LoadBalancerListener)obj;
            if (this.instancePort == null ? other.instancePort != null : !this.instancePort.equals(other.instancePort)) {
                return false;
            }
            if (this.loadBalancerPort == null ? other.loadBalancerPort != null : !this.loadBalancerPort.equals(other.loadBalancerPort)) {
                return false;
            }
            if (this.policyNames == null ? other.policyNames != null : !((Object)this.policyNames).equals(other.policyNames)) {
                return false;
            }
            return !(this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol));
        }
    }

    public static class LBCookieStickinessPolicy {
        private String policyName;
        private Integer cookieExpirationPeriod;

        public LBCookieStickinessPolicy() {
        }

        public LBCookieStickinessPolicy(String policyName, Integer cookieExpirationPeriod) {
            this.policyName = policyName;
            this.cookieExpirationPeriod = cookieExpirationPeriod;
        }

        public String getPolicyName() {
            return this.policyName;
        }

        public Integer getCookieExpirationPeriod() {
            return this.cookieExpirationPeriod;
        }

        public void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public void setCookieExpirationPeriod(Integer cookieExpirationPeriod) {
            this.cookieExpirationPeriod = cookieExpirationPeriod;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cookieExpirationPeriod == null ? 0 : this.cookieExpirationPeriod.hashCode());
            result = 31 * result + (this.policyName == null ? 0 : this.policyName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LBCookieStickinessPolicy other = (LBCookieStickinessPolicy)obj;
            if (this.cookieExpirationPeriod == null ? other.cookieExpirationPeriod != null : !this.cookieExpirationPeriod.equals(other.cookieExpirationPeriod)) {
                return false;
            }
            return !(this.policyName == null ? other.policyName != null : !this.policyName.equals(other.policyName));
        }
    }

    public static class AppCookieStickinessPolicy {
        private String policyName;
        private String cookieName;

        public AppCookieStickinessPolicy() {
        }

        public AppCookieStickinessPolicy(String policyName, String cookieName) {
            this.policyName = policyName;
            this.cookieName = cookieName;
        }

        public String getPolicyName() {
            return this.policyName;
        }

        public String getCookieName() {
            return this.cookieName;
        }

        public void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public void setCookieName(String cookieName) {
            this.cookieName = cookieName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cookieName == null ? 0 : this.cookieName.hashCode());
            result = 31 * result + (this.policyName == null ? 0 : this.policyName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AppCookieStickinessPolicy other = (AppCookieStickinessPolicy)obj;
            if (this.cookieName == null ? other.cookieName != null : !this.cookieName.equals(other.cookieName)) {
                return false;
            }
            return !(this.policyName == null ? other.policyName != null : !this.policyName.equals(other.policyName));
        }
    }
}

