/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.elb;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.aws.elb.domain.LoadBalancer;
import org.jclouds.aws.elb.xml.CreateLoadBalancerResponseHandler;
import org.jclouds.aws.elb.xml.DescribeLoadBalancersResponseHandler;
import org.jclouds.aws.elb.xml.RegisterInstancesWithLoadBalancerResponseHandler;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.aws.functions.RegionToEndpoint;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={FormSigner.class})
@FormParams(keys={"Version"}, values={"2009-11-25"})
@VirtualHost
public interface ELBAsyncClient {
    public static final String VERSION = "2009-11-25";

    @POST
    @Path(value="/")
    @XMLResponseParser(value=CreateLoadBalancerResponseHandler.class)
    @FormParams(keys={"Action"}, values={"CreateLoadBalancer"})
    public ListenableFuture<String> createLoadBalancerInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="LoadBalancerName") String var2, @FormParam(value="Listeners.member.1.Protocol") String var3, @FormParam(value="Listeners.member.1.LoadBalancerPort") int var4, @FormParam(value="Listeners.member.1.InstancePort") int var5, String ... var6);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeleteLoadBalancer"})
    public ListenableFuture<Void> deleteLoadBalancerInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="LoadBalancerName") String var2);

    @POST
    @Path(value="/")
    @XMLResponseParser(value=RegisterInstancesWithLoadBalancerResponseHandler.class)
    @FormParams(keys={"Action"}, values={"RegisterInstancesWithLoadBalancer"})
    public ListenableFuture<? extends Set<String>> registerInstancesWithLoadBalancerInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="LoadBalancerName") String var2, String ... var3);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeregisterInstancesFromLoadBalancer"})
    public ListenableFuture<Void> deregisterInstancesWithLoadBalancerInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1, @FormParam(value="LoadBalancerName") String var2, String ... var3);

    @POST
    @Path(value="/")
    @XMLResponseParser(value=DescribeLoadBalancersResponseHandler.class)
    @FormParams(keys={"Action"}, values={"DescribeLoadBalancers"})
    public ListenableFuture<? extends Set<LoadBalancer>> describeLoadBalancersInRegion(@EndpointParam(parser=RegionToEndpoint.class) @Nullable String var1);
}

