/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import javax.inject.Inject;
import org.jclouds.aws.Region;
import org.jclouds.aws.ec2.domain.ReservedInstancesOffering;
import org.jclouds.aws.ec2.util.EC2Utils;
import org.jclouds.http.functions.ParseSax;

public class ReservedInstancesOfferingHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<ReservedInstancesOffering> {
    @Inject
    @Region
    String defaultRegion;
    private StringBuilder currentText = new StringBuilder();
    private String availabilityZone;
    private long duration = 0L;
    private float fixedPrice = 0.0f;
    private String instanceType;
    private String productDescription;
    private String id;
    private float usagePrice = 0.0f;

    public ReservedInstancesOffering getResult() {
        String region = EC2Utils.findRegionInArgsOrNull(this.getRequest());
        if (region == null) {
            region = this.defaultRegion;
        }
        ReservedInstancesOffering returnVal = new ReservedInstancesOffering(region, this.availabilityZone, this.duration, this.fixedPrice, this.instanceType, this.productDescription, this.id, this.usagePrice);
        this.availabilityZone = null;
        this.duration = 0L;
        this.fixedPrice = 0.0f;
        this.instanceType = null;
        this.productDescription = null;
        this.id = null;
        this.usagePrice = 0.0f;
        return returnVal;
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equalsIgnoreCase("reservedInstancesOfferingId")) {
            this.id = this.currentText.toString().trim();
        } else if (qName.equalsIgnoreCase("availabilityZone")) {
            this.availabilityZone = this.currentText.toString().trim();
        } else if (qName.equalsIgnoreCase("duration")) {
            this.duration = Long.parseLong(this.currentText.toString().trim());
        } else if (qName.equalsIgnoreCase("fixedPrice")) {
            this.fixedPrice = Float.parseFloat(this.currentText.toString().trim());
        } else if (qName.equalsIgnoreCase("instanceType")) {
            this.instanceType = this.currentText.toString().trim();
        } else if (qName.equalsIgnoreCase("productDescription")) {
            this.productDescription = this.currentText.toString().trim();
        } else if (qName.equalsIgnoreCase("usagePrice")) {
            this.usagePrice = Float.parseFloat(this.currentText.toString().trim());
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

