/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import javax.inject.Inject;
import org.jclouds.aws.Region;
import org.jclouds.aws.ec2.domain.KeyPair;
import org.jclouds.aws.ec2.util.EC2Utils;
import org.jclouds.http.functions.ParseSax;

public class KeyPairResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<KeyPair> {
    @Inject
    @Region
    String defaultRegion;
    private StringBuilder currentText = new StringBuilder();
    private String keyFingerprint;
    private String keyMaterial;
    private String keyName;

    public KeyPair getResult() {
        String region = EC2Utils.findRegionInArgsOrNull(this.getRequest());
        if (region == null) {
            region = this.defaultRegion;
        }
        return new KeyPair(region, this.keyName, this.keyFingerprint, this.keyMaterial);
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("keyFingerprint")) {
            this.keyFingerprint = this.currentText.toString().trim();
        } else if (qName.equals("keyMaterial")) {
            this.keyMaterial = this.currentText.toString().trim();
        } else if (qName.equals("keyName")) {
            this.keyName = this.currentText.toString().trim();
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

