/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.aws.Region;
import org.jclouds.aws.ec2.domain.IpPermission;
import org.jclouds.aws.ec2.domain.IpProtocol;
import org.jclouds.aws.ec2.domain.SecurityGroup;
import org.jclouds.aws.ec2.domain.UserIdGroupPair;
import org.jclouds.aws.ec2.util.EC2Utils;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.Attributes;

public class DescribeSecurityGroupsResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Set<SecurityGroup>> {
    @Inject
    @Region
    String defaultRegion;
    private StringBuilder currentText = new StringBuilder();
    private Set<SecurityGroup> securtyGroups = Sets.newLinkedHashSet();
    private String groupName;
    private String ownerId;
    private String groupDescription;
    private Set<IpPermission> ipPermissions = Sets.newLinkedHashSet();
    private int fromPort;
    private int toPort;
    private Set<UserIdGroupPair> groups = Sets.newLinkedHashSet();
    private String userId;
    private String userIdGroupName;
    private IpProtocol ipProtocol;
    private Set<String> ipRanges = Sets.newLinkedHashSet();
    private boolean inIpPermissions;
    private boolean inIpRanges;
    private boolean inGroups;

    public Set<SecurityGroup> getResult() {
        return this.securtyGroups;
    }

    public void startElement(String uri, String name, String qName, Attributes attrs) {
        if (qName.equals("ipPermissions")) {
            this.inIpPermissions = true;
        } else if (qName.equals("ipRanges")) {
            this.inIpRanges = true;
        } else if (qName.equals("groups")) {
            this.inGroups = true;
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("groupName")) {
            if (!this.inGroups) {
                this.groupName = this.currentText.toString().trim();
            } else {
                this.userIdGroupName = this.currentText.toString().trim();
            }
        } else if (qName.equals("ownerId")) {
            this.ownerId = this.currentText.toString().trim();
        } else if (qName.equals("userId")) {
            this.userId = this.currentText.toString().trim();
        } else if (qName.equals("groupDescription")) {
            this.groupDescription = this.currentText.toString().trim();
        } else if (qName.equals("ipProtocol")) {
            this.ipProtocol = IpProtocol.fromValue(this.currentText.toString().trim());
        } else if (qName.equals("fromPort")) {
            this.fromPort = Integer.parseInt(this.currentText.toString().trim());
        } else if (qName.equals("toPort")) {
            this.toPort = Integer.parseInt(this.currentText.toString().trim());
        } else if (qName.equals("cidrIp")) {
            this.ipRanges.add(this.currentText.toString().trim());
        } else if (qName.equals("ipPermissions")) {
            this.inIpPermissions = false;
        } else if (qName.equals("ipRanges")) {
            this.inIpRanges = false;
        } else if (qName.equals("groups")) {
            this.inGroups = false;
        } else if (qName.equals("item")) {
            if (this.inIpPermissions && !this.inIpRanges && !this.inGroups) {
                this.ipPermissions.add(new IpPermission(this.fromPort, this.toPort, this.groups, this.ipProtocol, this.ipRanges));
                this.fromPort = -1;
                this.toPort = -1;
                this.groups = Sets.newLinkedHashSet();
                this.ipProtocol = null;
                this.ipRanges = Sets.newLinkedHashSet();
            } else if (this.inIpPermissions && !this.inIpRanges && this.inGroups) {
                this.groups.add(new UserIdGroupPair(this.userId, this.userIdGroupName));
                this.userId = null;
                this.userIdGroupName = null;
            } else if (!(this.inIpPermissions || this.inIpRanges || this.inGroups)) {
                String region = EC2Utils.findRegionInArgsOrNull(this.getRequest());
                if (region == null) {
                    region = this.defaultRegion;
                }
                this.securtyGroups.add(new SecurityGroup(region, this.groupName, this.ownerId, this.groupDescription, this.ipPermissions));
                this.groupName = null;
                this.ownerId = null;
                this.groupDescription = null;
                this.ipPermissions = Sets.newLinkedHashSet();
            }
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

