/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;
import javax.annotation.Resource;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;

public class DescribeRegionsResponseHandler
extends ParseSax.HandlerWithResult<Map<String, URI>> {
    private StringBuilder currentText = new StringBuilder();
    private Map<String, URI> regionEndpoints = Maps.newHashMap();
    private String region;
    private URI regionEndpoint;
    @Resource
    protected Logger logger = Logger.NULL;

    public Map<String, URI> getResult() {
        return this.regionEndpoints;
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("regionName")) {
            String pending = this.currentText.toString().trim();
            if (pending.indexOf("Walrus") == -1) {
                this.region = pending;
            }
        } else if (qName.equals("regionEndpoint") || qName.equals("regionUrl")) {
            String pending = this.currentText.toString().trim();
            if (pending.indexOf("Walrus") == -1) {
                this.regionEndpoint = URI.create(pending.startsWith("http") ? pending : String.format("https://%s", pending));
            }
        } else if (qName.equals("item") && this.region != null) {
            this.regionEndpoints.put(this.region, this.regionEndpoint);
            this.region = null;
            this.regionEndpoint = null;
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

