/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.aws.Region;
import org.jclouds.aws.ec2.domain.KeyPair;
import org.jclouds.aws.ec2.util.EC2Utils;
import org.jclouds.http.functions.ParseSax;

public class DescribeKeyPairsResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Set<KeyPair>> {
    @Inject
    @Region
    String defaultRegion;
    private StringBuilder currentText = new StringBuilder();
    private Set<KeyPair> keyPairs = Sets.newLinkedHashSet();
    private String keyFingerprint;
    private String keyName;

    public Set<KeyPair> getResult() {
        return this.keyPairs;
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("keyFingerprint")) {
            this.keyFingerprint = this.currentText.toString().trim();
        } else if (qName.equals("item")) {
            String region = EC2Utils.findRegionInArgsOrNull(this.getRequest());
            if (region == null) {
                region = this.defaultRegion;
            }
            this.keyPairs.add(new KeyPair(region, this.keyName, this.keyFingerprint, null));
        } else if (qName.equals("keyName")) {
            this.keyName = this.currentText.toString().trim();
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

