/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.aws.Region;
import org.jclouds.aws.ec2.domain.Attachment;
import org.jclouds.aws.ec2.domain.InstanceState;
import org.jclouds.aws.ec2.domain.MonitoringState;
import org.jclouds.aws.ec2.domain.Reservation;
import org.jclouds.aws.ec2.domain.RootDeviceType;
import org.jclouds.aws.ec2.domain.RunningInstance;
import org.jclouds.aws.ec2.util.EC2Utils;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;
import org.xml.sax.Attributes;

public abstract class BaseReservationHandler<T>
extends ParseSax.HandlerForGeneratedRequestWithResult<T> {
    protected final DateService dateService;
    protected final String defaultRegion;
    @Resource
    protected Logger logger = Logger.NULL;
    private StringBuilder currentText = new StringBuilder();
    private Set<String> groupIds = Sets.newLinkedHashSet();
    private Set<RunningInstance> instances = Sets.newLinkedHashSet();
    private String ownerId;
    private String requesterId;
    private String reservationId;
    private String amiLaunchIndex;
    private String dnsName;
    private String imageId;
    private String instanceId;
    private InstanceState instanceState;
    private String instanceType;
    private String ipAddress;
    private String kernelId;
    private String keyName;
    private Date launchTime;
    private MonitoringState monitoringState;
    private String availabilityZone;
    private String placementGroup;
    private String virtualizationType = "paravirtual";
    private String platform;
    private String privateDnsName;
    private String privateIpAddress;
    private Set<String> productCodes = Sets.newHashSet();
    private String ramdiskId;
    private String reason;
    private String spotInstanceRequestId;
    private String subnetId;
    private String vpcId;
    protected boolean inInstances;
    protected boolean inProductCodes;
    protected boolean inGroups;
    protected boolean inMonitoring;
    private boolean inBlockDeviceMapping;
    private Map<String, RunningInstance.EbsBlockDevice> ebsBlockDevices = Maps.newHashMap();
    private String volumeId;
    private Attachment.Status attachmentStatus;
    private Date attachTime;
    private boolean deleteOnTermination;
    private RootDeviceType rootDeviceType = RootDeviceType.INSTANCE_STORE;
    private String deviceName;
    private String rootDeviceName;

    @Inject
    public BaseReservationHandler(DateService dateService, @Region String defaultRegion) {
        this.dateService = dateService;
        this.defaultRegion = defaultRegion;
    }

    public void startElement(String uri, String name, String qName, Attributes attrs) {
        if (qName.equals("instancesSet")) {
            this.inInstances = true;
        } else if (qName.equals("productCodesSet")) {
            this.inProductCodes = true;
        } else if (qName.equals("groupSet")) {
            this.inGroups = true;
        } else if (qName.equals("blockDeviceMapping")) {
            this.inBlockDeviceMapping = true;
        }
        if (qName.equals("monitoring")) {
            this.inMonitoring = true;
        }
    }

    protected String currentOrNull() {
        String returnVal = this.currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("groupId")) {
            this.groupIds.add(this.currentOrNull());
        } else if (qName.equals("ownerId")) {
            this.ownerId = this.currentOrNull();
        } else if (qName.equals("requesterId")) {
            this.requesterId = this.currentOrNull();
        } else if (qName.equals("reservationId")) {
            this.reservationId = this.currentOrNull();
        } else if (qName.equals("amiLaunchIndex")) {
            this.amiLaunchIndex = this.currentOrNull();
        } else if (qName.equals("dnsName")) {
            this.dnsName = this.currentOrNull();
            if ("0.0.0.0".equals(this.dnsName)) {
                this.dnsName = null;
            }
        } else if (qName.equals("imageId")) {
            this.imageId = this.currentOrNull();
        } else if (qName.equals("instanceId")) {
            this.instanceId = this.currentOrNull();
        } else if (qName.equals("name")) {
            String state = this.currentOrNull();
            if (state != null) {
                this.instanceState = "shutdown".equalsIgnoreCase(state) ? InstanceState.TERMINATED : InstanceState.fromValue(state);
            }
        } else if (qName.equals("instanceType")) {
            this.instanceType = this.currentOrNull();
        } else if (qName.equals("ipAddress")) {
            this.ipAddress = this.currentOrNull();
        } else if (qName.equals("kernelId")) {
            this.kernelId = this.currentOrNull();
        } else if (qName.equals("keyName")) {
            this.keyName = this.currentOrNull();
        } else if (qName.equals("launchTime")) {
            try {
                this.launchTime = this.dateService.iso8601DateParse(this.currentOrNull());
            }
            catch (RuntimeException e) {
                this.launchTime = this.dateService.iso8601SecondsDateParse(this.currentOrNull());
            }
        } else if (qName.equals("state") && this.inMonitoring) {
            this.monitoringState = MonitoringState.fromValue(this.currentOrNull());
        } else if (qName.equals("availabilityZone")) {
            this.availabilityZone = this.currentOrNull();
        } else if (qName.equals("groupName")) {
            this.placementGroup = this.currentOrNull();
        } else if (qName.equals("virtualizationType")) {
            this.virtualizationType = this.currentOrNull();
        } else if (qName.equals("platform")) {
            this.platform = this.currentOrNull();
        } else if (qName.equals("privateDnsName")) {
            this.privateDnsName = this.currentOrNull();
            if ("0.0.0.0".equals(this.privateDnsName)) {
                this.privateDnsName = null;
            }
        } else if (qName.equals("privateIpAddress")) {
            this.privateIpAddress = this.currentOrNull();
        } else if (qName.equals("ramdiskId")) {
            this.ramdiskId = this.currentOrNull();
        } else if (qName.equals("reason")) {
            this.reason = this.currentOrNull();
        } else if (qName.equals("subnetId")) {
            this.subnetId = this.currentOrNull();
        } else if (qName.equals("spotInstanceRequestId")) {
            this.spotInstanceRequestId = this.currentOrNull();
        } else if (qName.equals("vpcId")) {
            this.vpcId = this.currentOrNull();
        } else if (qName.equals("productCode")) {
            this.productCodes.add(this.currentOrNull());
        } else if (qName.equals("productCodesSet")) {
            this.inProductCodes = false;
        } else if (qName.equals("instancesSet")) {
            this.inInstances = false;
        } else if (qName.equals("groupSet")) {
            this.inGroups = false;
        } else if (qName.equals("monitoring")) {
            this.inMonitoring = false;
        } else if (qName.equals("blockDeviceMapping")) {
            this.inBlockDeviceMapping = false;
        } else if (qName.equals("deviceName")) {
            this.deviceName = this.currentOrNull();
        } else if (qName.equals("rootDeviceType")) {
            this.rootDeviceType = RootDeviceType.fromValue(this.currentOrNull());
        } else if (qName.equals("volumeId")) {
            this.volumeId = this.currentOrNull();
        } else if (qName.equals("status")) {
            this.attachmentStatus = Attachment.Status.fromValue(this.currentText.toString().trim());
        } else if (qName.equals("attachTime")) {
            this.attachTime = this.dateService.iso8601DateParse(this.currentText.toString().trim());
        } else if (qName.equals("deleteOnTermination")) {
            this.deleteOnTermination = Boolean.parseBoolean(this.currentText.toString().trim());
        } else if (qName.equals("rootDeviceName")) {
            this.rootDeviceName = this.currentOrNull();
        } else if (qName.equals("item")) {
            this.inItem();
        }
        this.currentText = new StringBuilder();
    }

    protected void inItem() {
        if (this.inBlockDeviceMapping) {
            this.ebsBlockDevices.put(this.deviceName, new RunningInstance.EbsBlockDevice(this.volumeId, this.attachmentStatus, this.attachTime, this.deleteOnTermination));
            this.deviceName = null;
            this.volumeId = null;
            this.attachmentStatus = null;
            this.attachTime = null;
            this.deleteOnTermination = true;
        } else if (this.inInstances && !this.inProductCodes && !this.inBlockDeviceMapping) {
            String region;
            String string = region = this.getRequest() != null ? EC2Utils.findRegionInArgsOrNull(this.getRequest()) : null;
            if (this.ipAddress == null && this.dnsName != null && this.dnsName.matches(".*[0-9]$")) {
                this.ipAddress = this.dnsName;
                this.dnsName = null;
            }
            if (this.privateIpAddress == null && this.privateDnsName != null && this.privateDnsName.matches(".*[0-9]$")) {
                this.privateIpAddress = this.privateDnsName;
                this.privateDnsName = null;
            }
            if (region == null) {
                region = this.defaultRegion;
            }
            this.instances.add(new RunningInstance(region, this.groupIds, this.amiLaunchIndex, this.dnsName, this.imageId, this.instanceId, this.instanceState, this.instanceType, this.ipAddress, this.kernelId, this.keyName, this.launchTime, this.monitoringState, this.availabilityZone, this.placementGroup, this.virtualizationType, this.platform, this.privateDnsName, this.privateIpAddress, this.productCodes, this.ramdiskId, this.reason, this.subnetId, this.spotInstanceRequestId, this.vpcId, this.rootDeviceType, this.rootDeviceName, this.ebsBlockDevices));
            this.amiLaunchIndex = null;
            this.dnsName = null;
            this.imageId = null;
            this.instanceId = null;
            this.instanceState = null;
            this.instanceType = null;
            this.ipAddress = null;
            this.kernelId = null;
            this.keyName = null;
            this.launchTime = null;
            this.monitoringState = null;
            this.availabilityZone = null;
            this.placementGroup = null;
            this.virtualizationType = "paravirtual";
            this.platform = null;
            this.privateDnsName = null;
            this.privateIpAddress = null;
            this.productCodes = Sets.newHashSet();
            this.ramdiskId = null;
            this.reason = null;
            this.subnetId = null;
            this.spotInstanceRequestId = null;
            this.vpcId = null;
            this.rootDeviceType = RootDeviceType.INSTANCE_STORE;
            this.rootDeviceName = null;
            this.ebsBlockDevices = Maps.newHashMap();
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    protected Reservation<? extends RunningInstance> newReservation() {
        String region;
        String string = region = this.getRequest() != null ? EC2Utils.findRegionInArgsOrNull(this.getRequest()) : null;
        if (region == null) {
            region = this.defaultRegion;
        }
        Reservation<RunningInstance> info = new Reservation<RunningInstance>(region, this.groupIds, this.instances, this.ownerId, this.requesterId, this.reservationId);
        this.groupIds = Sets.newLinkedHashSet();
        this.instances = Sets.newLinkedHashSet();
        this.ownerId = null;
        this.requesterId = null;
        this.reservationId = null;
        return info;
    }
}

