/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import java.util.Date;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.aws.Region;
import org.jclouds.aws.ec2.domain.Attachment;
import org.jclouds.aws.ec2.util.EC2Utils;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;

public class AttachmentHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Attachment> {
    private StringBuilder currentText = new StringBuilder();
    @Resource
    protected Logger logger = Logger.NULL;
    @Inject
    protected DateService dateService;
    @Inject
    @Region
    String defaultRegion;
    private String volumeId;
    private String instanceId;
    private String device;
    private Attachment.Status attachmentStatus;
    private Date attachTime;

    public Attachment getResult() {
        String region = EC2Utils.findRegionInArgsOrNull(this.getRequest());
        if (region == null) {
            region = this.defaultRegion;
        }
        return new Attachment(region, this.volumeId, this.instanceId, this.device, this.attachmentStatus, this.attachTime);
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("volumeId")) {
            this.volumeId = this.currentText.toString().trim();
        } else if (qName.equals("volumeId")) {
            this.volumeId = this.currentText.toString().trim();
        } else if (qName.equals("status")) {
            this.attachmentStatus = Attachment.Status.fromValue(this.currentText.toString().trim());
        } else if (qName.equals("instanceId")) {
            this.instanceId = this.currentText.toString().trim();
        } else if (qName.equals("device")) {
            this.device = this.currentText.toString().trim();
        } else if (qName.equals("attachTime")) {
            this.attachTime = this.dateService.iso8601DateParse(this.currentText.toString().trim());
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

